/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.function;

import com.microsoft.azure.maven.function.AbstractFunctionMojo;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.appservice.AzureAppService;
import com.microsoft.azure.toolkit.lib.appservice.config.AppServiceConfig;
import com.microsoft.azure.toolkit.lib.appservice.config.FunctionAppConfig;
import com.microsoft.azure.toolkit.lib.appservice.config.RuntimeConfig;
import com.microsoft.azure.toolkit.lib.appservice.model.FunctionDeployType;
import com.microsoft.azure.toolkit.lib.appservice.model.JavaVersion;
import com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem;
import com.microsoft.azure.toolkit.lib.appservice.model.PricingTier;
import com.microsoft.azure.toolkit.lib.appservice.service.IAppService;
import com.microsoft.azure.toolkit.lib.appservice.service.IAppServicePlan;
import com.microsoft.azure.toolkit.lib.appservice.service.IFunctionApp;
import com.microsoft.azure.toolkit.lib.appservice.service.IFunctionAppBase;
import com.microsoft.azure.toolkit.lib.appservice.task.CreateOrUpdateFunctionAppTask;
import com.microsoft.azure.toolkit.lib.appservice.task.DeployFunctionAppTask;
import com.microsoft.azure.toolkit.lib.appservice.utils.AppServiceConfigUtils;
import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.exception.AzureExecutionException;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.model.Region;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.common.utils.Utils;
import java.io.File;
import java.util.Arrays;
import java.util.Optional;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

@Mojo(name="deploy", defaultPhase=LifecyclePhase.DEPLOY)
public class DeployMojo
extends AbstractFunctionMojo {
    private static final String APPLICATION_INSIGHTS_CONFIGURATION_CONFLICT = "Contradictory configurations for application insights, specify 'appInsightsKey' or 'appInsightsInstance' if you want to enable it, and specify 'disableAppInsights=true' if you want to disable it.";
    private static final String ARTIFACT_INCOMPATIBLE_WARNING = "Your function app artifact compile version {0} may not compatible with java version {1} in configuration.";
    private static final String ARTIFACT_INCOMPATIBLE_ERROR = "Your function app artifact compile version {0} is not compatible with java version {1} in configuration, please downgrade the project compile version and try again.";
    private static final String NO_ARTIFACT_FOUNDED = "Failed to find function artifact '%s.jar' in folder '%s', please re-package the project and try again.";
    private static final String APP_NAME_PATTERN = "[a-zA-Z0-9\\-]{2,60}";
    private static final String RESOURCE_GROUP_PATTERN = "[a-zA-Z0-9._\\-()]{1,90}";
    private static final String SLOT_NAME_PATTERN = "[A-Za-z0-9-]{1,60}";
    private static final String APP_SERVICE_PLAN_NAME_PATTERN = "[a-zA-Z0-9\\-]{1,40}";
    private static final String EMPTY_APP_NAME = "Please config the <appName> in pom.xml.";
    private static final String INVALID_APP_NAME = "The <appName> only allow alphanumeric characters, hyphens and cannot start or end in a hyphen.";
    private static final String EMPTY_RESOURCE_GROUP = "Please config the <resourceGroup> in pom.xml.";
    private static final String INVALID_RESOURCE_GROUP_NAME = "The <resourceGroup> only allow alphanumeric characters, periods, underscores, hyphens and parenthesis and cannot end in a period.";
    private static final String INVALID_SERVICE_PLAN_NAME = "Invalid value for <appServicePlanName>, it need to match the pattern %s";
    private static final String INVALID_SERVICE_PLAN_RESOURCE_GROUP_NAME = "Invalid value for <appServicePlanResourceGroup>, it only allow alphanumeric characters, periods, underscores, hyphens and parenthesis and cannot end in a period.";
    private static final String EMPTY_SLOT_NAME = "Please config the <name> of <deploymentSlot> in pom.xml";
    private static final String INVALID_SLOT_NAME = "Invalid value of <name> inside <deploymentSlot> in pom.xml, it needs to match the pattern '%s'";
    private static final String EMPTY_IMAGE_NAME = "Please config the <image> of <runtime> in pom.xml.";
    private static final String INVALID_OS = "The value of <os> is not correct, supported values are: windows, linux and docker.";
    private static final String EXPANDABLE_PRICING_TIER_WARNING = "'%s' may not be a valid pricing tier, please refer to https://aka.ms/maven_function_configuration#supported-pricing-tiers for valid values";
    private static final String EXPANDABLE_REGION_WARNING = "'%s' may not be a valid region, please refer to https://aka.ms/maven_function_configuration#supported-regions for valid values";
    private static final String EXPANDABLE_JAVA_VERSION_WARNING = "'%s' may not be a valid java version, recommended values are `Java 8` and `Java 11`";
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @AzureOperation(name="functionapp|mojo.deploy", type=AzureOperation.Type.ACTION)
    protected void doExecute() throws AzureExecutionException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            this.doValidate();
            this.getOrCreateAzureAppServiceClient();
            IFunctionAppBase<?> target = this.createOrUpdateResource(this.getParser().parseConfig());
            this.deployArtifact(target);
            this.updateTelemetryProperties();
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    protected void doValidate() throws AzureExecutionException {
        this.validateParameters();
        this.validateArtifactCompileVersion();
        this.validateApplicationInsightsConfiguration();
    }

    @Deprecated
    protected void validateParameters() {
        if (StringUtils.isBlank((CharSequence)this.appName)) {
            throw new AzureToolkitRuntimeException(EMPTY_APP_NAME);
        }
        if (this.appName.startsWith("-") || !this.appName.matches(APP_NAME_PATTERN)) {
            throw new AzureToolkitRuntimeException(INVALID_APP_NAME);
        }
        if (StringUtils.isBlank((CharSequence)this.resourceGroup)) {
            throw new AzureToolkitRuntimeException(EMPTY_RESOURCE_GROUP);
        }
        if (this.resourceGroup.endsWith(".") || !this.resourceGroup.matches(RESOURCE_GROUP_PATTERN)) {
            throw new AzureToolkitRuntimeException(INVALID_RESOURCE_GROUP_NAME);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.appServicePlanName) && !this.appServicePlanName.matches(APP_SERVICE_PLAN_NAME_PATTERN)) {
            throw new AzureToolkitRuntimeException(String.format(INVALID_SERVICE_PLAN_NAME, APP_SERVICE_PLAN_NAME_PATTERN));
        }
        if (StringUtils.isNotEmpty((CharSequence)this.appServicePlanResourceGroup) && (this.appServicePlanResourceGroup.endsWith(".") || !this.appServicePlanResourceGroup.matches(RESOURCE_GROUP_PATTERN))) {
            throw new AzureToolkitRuntimeException(INVALID_SERVICE_PLAN_RESOURCE_GROUP_NAME);
        }
        if (this.deploymentSlotSetting != null && StringUtils.isEmpty((CharSequence)this.deploymentSlotSetting.getName())) {
            throw new AzureToolkitRuntimeException(EMPTY_SLOT_NAME);
        }
        if (this.deploymentSlotSetting != null && !this.deploymentSlotSetting.getName().matches(SLOT_NAME_PATTERN)) {
            throw new AzureToolkitRuntimeException(String.format(INVALID_SLOT_NAME, SLOT_NAME_PATTERN));
        }
        if (StringUtils.isNotEmpty((CharSequence)this.region) && Region.fromName((String)this.region).isExpandedValue()) {
            AzureMessager.getMessager().warning(String.format(EXPANDABLE_REGION_WARNING, this.region));
        }
        if (StringUtils.isNotEmpty((CharSequence)this.runtime.getOs()) && OperatingSystem.fromString((String)this.runtime.getOs()) == null) {
            throw new AzureToolkitRuntimeException(INVALID_OS);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.runtime.getJavaVersion()) && JavaVersion.fromString((String)this.runtime.getJavaVersion()).isExpandedValue()) {
            AzureMessager.getMessager().warning(String.format(EXPANDABLE_JAVA_VERSION_WARNING, this.runtime.getJavaVersion()));
        }
        if (StringUtils.isNotEmpty((CharSequence)this.pricingTier) && PricingTier.fromString((String)this.pricingTier).isExpandedValue()) {
            AzureMessager.getMessager().warning(String.format(EXPANDABLE_PRICING_TIER_WARNING, this.pricingTier));
        }
        if (OperatingSystem.fromString((String)this.runtime.getOs()) == OperatingSystem.DOCKER && StringUtils.isEmpty((CharSequence)this.runtime.getImage())) {
            throw new AzureToolkitRuntimeException(EMPTY_IMAGE_NAME);
        }
    }

    protected IFunctionAppBase<?> createOrUpdateResource(FunctionAppConfig config) {
        IFunctionApp app = ((AzureAppService)Azure.az(AzureAppService.class)).functionApp(config.resourceGroup(), config.appName());
        boolean newFunctionApp = !app.exists();
        AppServiceConfig defaultConfig = !newFunctionApp ? AppServiceConfigUtils.fromAppService((IAppService)app, (IAppServicePlan)app.plan()) : this.buildDefaultConfig(config.subscriptionId(), config.resourceGroup(), config.appName());
        AppServiceConfigUtils.mergeAppServiceConfig((AppServiceConfig)config, (AppServiceConfig)defaultConfig);
        if (!newFunctionApp && !config.disableAppInsights() && StringUtils.isEmpty((CharSequence)config.appInsightsKey())) {
            config.appInsightsKey((String)app.entity().getAppSettings().get("APPINSIGHTS_INSTRUMENTATIONKEY"));
        }
        return new CreateOrUpdateFunctionAppTask(config).execute();
    }

    private AppServiceConfig buildDefaultConfig(String subscriptionId, String resourceGroup, String appName) {
        ComparableVersion javaVersionForProject = null;
        String outputFileName = this.project.getBuild().getFinalName() + "." + this.project.getPackaging();
        File outputFile = new File(this.project.getBuild().getDirectory(), outputFileName);
        if (outputFile.exists() && StringUtils.equalsIgnoreCase((CharSequence)"jar", (CharSequence)FilenameUtils.getExtension((String)outputFile.getName()))) {
            try {
                javaVersionForProject = new ComparableVersion(Utils.getArtifactCompileVersion((File)outputFile));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        JavaVersion javaVersion = (javaVersionForProject = (ComparableVersion)ObjectUtils.firstNonNull((Object[])new ComparableVersion[]{javaVersionForProject, new ComparableVersion(System.getProperty("java.version"))})).compareTo(new ComparableVersion("9")) < 0 ? JavaVersion.JAVA_8 : JavaVersion.JAVA_11;
        return AppServiceConfigUtils.buildDefaultFunctionConfig((String)subscriptionId, (String)resourceGroup, (String)appName, (JavaVersion)javaVersion);
    }

    private void deployArtifact(IFunctionAppBase<?> target) {
        File file = new File(this.getDeploymentStagingDirectoryPath());
        FunctionDeployType type = StringUtils.isEmpty((CharSequence)this.deploymentType) ? null : FunctionDeployType.fromString((String)this.deploymentType);
        new DeployFunctionAppTask(target, file, type).execute();
    }

    protected void validateArtifactCompileVersion() throws AzureExecutionException {
        ComparableVersion artifactVersion;
        RuntimeConfig runtimeConfig = this.getParser().getRuntimeConfig();
        if (runtimeConfig.os() == OperatingSystem.DOCKER) {
            return;
        }
        JavaVersion javaVersion = Optional.ofNullable(runtimeConfig.javaVersion()).orElse(CreateOrUpdateFunctionAppTask.DEFAULT_FUNCTION_JAVA_VERSION);
        ComparableVersion runtimeVersion = new ComparableVersion(javaVersion.getValue());
        if (runtimeVersion.compareTo(artifactVersion = new ComparableVersion(Utils.getArtifactCompileVersion((File)this.getArtifactToDeploy()))) >= 0) {
            return;
        }
        if (!javaVersion.isExpandedValue()) {
            String errorMessage = AzureString.format((String)ARTIFACT_INCOMPATIBLE_ERROR, (Object[])new Object[]{artifactVersion.toString(), runtimeVersion.toString()}).toString();
            throw new AzureExecutionException(errorMessage);
        }
        AzureMessager.getMessager().warning(AzureString.format((String)ARTIFACT_INCOMPATIBLE_WARNING, (Object[])new Object[]{artifactVersion.toString(), runtimeVersion.toString()}));
    }

    private File getArtifactToDeploy() throws AzureExecutionException {
        File stagingFolder = new File(this.getDeploymentStagingDirectoryPath());
        return Arrays.stream(Optional.ofNullable(stagingFolder.listFiles()).orElse(new File[0])).filter(jar -> StringUtils.equals((CharSequence)FilenameUtils.getBaseName((String)jar.getName()), (CharSequence)this.getFinalName())).findFirst().orElseThrow(() -> new AzureExecutionException(String.format(NO_ARTIFACT_FOUNDED, this.getFinalName(), stagingFolder)));
    }

    private void validateApplicationInsightsConfiguration() throws AzureExecutionException {
        if (this.isDisableAppInsights() && (StringUtils.isNotEmpty((CharSequence)this.getAppInsightsKey()) || StringUtils.isNotEmpty((CharSequence)this.getAppInsightsInstance()))) {
            throw new AzureExecutionException(APPLICATION_INSIGHTS_CONFIGURATION_CONFLICT);
        }
    }

    static {
        DeployMojo.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("DeployMojo.java", DeployMojo.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "doExecute", "com.microsoft.azure.maven.function.DeployMojo", "", "", "com.microsoft.azure.toolkit.lib.common.exception.AzureExecutionException", "void"), 81);
    }
}

