/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.function.handlers;

import com.microsoft.azure.management.appservice.AppSetting;
import com.microsoft.azure.management.appservice.FunctionApp;
import com.microsoft.azure.maven.function.AbstractFunctionMojo;
import com.microsoft.azure.maven.function.AzureStorageHelper;
import com.microsoft.azure.maven.function.handlers.ArtifactHandler;
import com.microsoft.azure.storage.CloudStorageAccount;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.codehaus.plexus.util.StringUtils;
import org.zeroturnaround.zip.ZipUtil;

public class MSDeployArtifactHandlerImpl
implements ArtifactHandler {
    public static final String DEPLOYMENT_PACKAGE_CONTAINER = "java-functions-deployment-packages";
    public static final String ZIP_EXT = ".zip";
    public static final String CREATE_ZIP_START = "Step 1 of 4: Creating ZIP package...";
    public static final String CREATE_ZIP_DONE = "Successfully saved ZIP package at ";
    public static final String STAGE_DIR_NOT_FOUND = "Function App stage directory not found. Please run 'mvn package azure-functions:package' first.";
    public static final String LOCAL_SETTINGS_FILE = "local.settings.json";
    public static final String REMOVE_LOCAL_SETTINGS = "Remove local.settings.json from ZIP package.";
    public static final String INTERNAL_STORAGE_KEY = "AzureWebJobsStorage";
    public static final String INTERNAL_STORAGE_NOT_FOUND = "Application setting 'AzureWebJobsStorage' not found.";
    public static final String INTERNAL_STORAGE_CONNECTION_STRING = "Function App Internal Storage Connection String: ";
    public static final String UPLOAD_PACKAGE_START = "Step 2 of 4: Uploading ZIP package to Azure Storage...";
    public static final String UPLOAD_PACKAGE_DONE = "Successfully uploaded ZIP package to ";
    public static final String DEPLOY_PACKAGE_START = "Step 3 of 4: Deploying Function App with package...";
    public static final String DEPLOY_PACKAGE_DONE = "Successfully deployed Function App with package.";
    public static final String DELETE_PACKAGE_START = "Step 4 of 4: Deleting deployment package from Azure Storage...";
    public static final String DELETE_PACKAGE_DONE = "Successfully deleted deployment package ";
    public static final String DELETE_PACKAGE_FAIL = "Failed to delete deployment package ";
    private AbstractFunctionMojo mojo;

    public MSDeployArtifactHandlerImpl(AbstractFunctionMojo mojo) {
        this.mojo = mojo;
    }

    @Override
    public void publish() throws Exception {
        File zipPackage = this.createZipPackage();
        FunctionApp app = this.mojo.getFunctionApp();
        CloudStorageAccount storageAccount = this.getCloudStorageAccount(app);
        String blobName = this.getBlobName();
        String packageUri = this.uploadPackageToAzureStorage(zipPackage, storageAccount, blobName);
        this.deployWithPackageUri(app, packageUri, () -> this.deletePackageFromAzureStorage(storageAccount, blobName));
    }

    protected void logInfo(String message) {
        if (this.mojo != null) {
            this.mojo.getLog().info((CharSequence)message);
        }
    }

    protected void logDebug(String message) {
        if (this.mojo != null) {
            this.mojo.getLog().debug((CharSequence)message);
        }
    }

    protected void logError(String message) {
        if (this.mojo != null) {
            this.mojo.getLog().error((CharSequence)message);
        }
    }

    protected File createZipPackage() throws Exception {
        this.logInfo("");
        this.logInfo(CREATE_ZIP_START);
        String stageDirectoryPath = this.mojo.getDeploymentStageDirectory();
        File stageDirectory = new File(stageDirectoryPath);
        File zipPackage = new File(stageDirectoryPath.concat(ZIP_EXT));
        if (!stageDirectory.exists()) {
            this.logError(STAGE_DIR_NOT_FOUND);
            throw new Exception(STAGE_DIR_NOT_FOUND);
        }
        ZipUtil.pack((File)stageDirectory, (File)zipPackage);
        this.logDebug(REMOVE_LOCAL_SETTINGS);
        ZipUtil.removeEntry((File)zipPackage, (String)LOCAL_SETTINGS_FILE);
        this.logInfo(CREATE_ZIP_DONE + stageDirectoryPath.concat(ZIP_EXT));
        return zipPackage;
    }

    protected CloudStorageAccount getCloudStorageAccount(FunctionApp app) throws Exception {
        AppSetting internalStorageSetting = (AppSetting)app.appSettings().get(INTERNAL_STORAGE_KEY);
        if (internalStorageSetting == null || StringUtils.isEmpty((String)internalStorageSetting.value())) {
            this.logError(INTERNAL_STORAGE_NOT_FOUND);
            throw new Exception(INTERNAL_STORAGE_NOT_FOUND);
        }
        this.logDebug(INTERNAL_STORAGE_CONNECTION_STRING + internalStorageSetting.value());
        return CloudStorageAccount.parse((String)internalStorageSetting.value());
    }

    protected String getBlobName() {
        return this.mojo.getAppName().concat(new SimpleDateFormat(".yyyyMMddHHmmssSSS").format(new Date())).concat(ZIP_EXT);
    }

    protected String uploadPackageToAzureStorage(File zipPackage, CloudStorageAccount storageAccount, String blobName) throws Exception {
        this.logInfo("");
        this.logInfo(UPLOAD_PACKAGE_START);
        String packageUri = AzureStorageHelper.uploadFileAsBlob(zipPackage, storageAccount, DEPLOYMENT_PACKAGE_CONTAINER, blobName);
        this.logInfo(UPLOAD_PACKAGE_DONE + packageUri);
        return packageUri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deployWithPackageUri(FunctionApp app, String packageUri, Runnable onDeployFinish) {
        try {
            this.logInfo("");
            this.logInfo(DEPLOY_PACKAGE_START);
            app.deploy().withPackageUri(packageUri).withExistingDeploymentsDeleted(false).execute();
            this.logInfo(DEPLOY_PACKAGE_DONE);
        }
        finally {
            onDeployFinish.run();
        }
    }

    protected void deletePackageFromAzureStorage(CloudStorageAccount storageAccount, String blobName) {
        try {
            this.logInfo("");
            this.logInfo(DELETE_PACKAGE_START);
            AzureStorageHelper.deleteBlob(storageAccount, DEPLOYMENT_PACKAGE_CONTAINER, blobName);
            this.logInfo(DELETE_PACKAGE_DONE + blobName);
        }
        catch (Exception e) {
            this.logError(DELETE_PACKAGE_FAIL + blobName);
        }
    }
}

