/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.function.handlers;

import com.microsoft.azure.maven.function.bindings.BaseBinding;
import com.microsoft.azure.maven.function.bindings.BindingFactory;
import com.microsoft.azure.maven.function.bindings.HttpBinding;
import com.microsoft.azure.maven.function.bindings.StorageBaseBinding;
import com.microsoft.azure.maven.function.configurations.FunctionConfiguration;
import com.microsoft.azure.maven.function.handlers.AnnotationHandler;
import com.microsoft.azure.serverless.functions.annotation.FunctionName;
import com.microsoft.azure.serverless.functions.annotation.HttpTrigger;
import com.microsoft.azure.serverless.functions.annotation.StorageAccount;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.StringUtils;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.MethodAnnotationsScanner;
import org.reflections.scanners.Scanner;
import org.reflections.util.ConfigurationBuilder;

public class AnnotationHandlerImpl
implements AnnotationHandler {
    protected Log log;

    public AnnotationHandlerImpl(Log log) {
        this.log = log;
    }

    @Override
    public Set<Method> findFunctions(URL url) {
        return new Reflections((Configuration)new ConfigurationBuilder().addUrls(new URL[]{url}).addScanners(new Scanner[]{new MethodAnnotationsScanner()}).addClassLoader(this.getClassLoader(url))).getMethodsAnnotatedWith(FunctionName.class);
    }

    protected ClassLoader getClassLoader(URL url) {
        return new URLClassLoader(new URL[]{url}, this.getClass().getClassLoader());
    }

    @Override
    public Map<String, FunctionConfiguration> generateConfigurations(Set<Method> methods) throws Exception {
        HashMap<String, FunctionConfiguration> configMap = new HashMap<String, FunctionConfiguration>();
        for (Method method : methods) {
            FunctionName functionAnnotation = method.getAnnotation(FunctionName.class);
            String functionName = functionAnnotation.value();
            this.validateFunctionName(configMap.keySet(), functionName);
            this.log.debug((CharSequence)("Starting processing function : " + functionName));
            configMap.put(functionName, this.generateConfiguration(method));
        }
        return configMap;
    }

    protected void validateFunctionName(Set<String> nameSet, String functionName) throws Exception {
        if (StringUtils.isEmpty((String)functionName)) {
            throw new Exception("Azure Function name cannot be empty.");
        }
        if (nameSet.stream().anyMatch(n -> StringUtils.equalsIgnoreCase((String)n, (String)functionName))) {
            throw new Exception("Found duplicate Azure Function: " + functionName);
        }
    }

    @Override
    public FunctionConfiguration generateConfiguration(Method method) {
        FunctionConfiguration config = new FunctionConfiguration();
        List<BaseBinding> bindings = config.getBindings();
        this.processParameterAnnotations(method, bindings);
        this.processMethodAnnotations(method, bindings);
        this.patchStorageBinding(method, bindings);
        config.setEntryPoint(method.getDeclaringClass().getCanonicalName() + "." + method.getName());
        return config;
    }

    protected void processParameterAnnotations(Method method, List<BaseBinding> bindings) {
        for (Parameter param : method.getParameters()) {
            bindings.addAll(this.parseAnnotations(param::getAnnotations, this::parseParameterAnnotation));
        }
    }

    protected void processMethodAnnotations(Method method, List<BaseBinding> bindings) {
        if (!method.getReturnType().equals(Void.TYPE)) {
            bindings.addAll(this.parseAnnotations(method::getAnnotations, this::parseMethodAnnotation));
            if (bindings.stream().anyMatch(b -> b.getType().equalsIgnoreCase(HttpTrigger.class.getSimpleName())) && bindings.stream().noneMatch(b -> b.getName().equalsIgnoreCase("$return"))) {
                bindings.add(new HttpBinding());
            }
        }
    }

    protected List<BaseBinding> parseAnnotations(Supplier<Annotation[]> annotationProvider, Function<Annotation, BaseBinding> annotationParser) {
        ArrayList<BaseBinding> bindings = new ArrayList<BaseBinding>();
        for (Annotation annotation : annotationProvider.get()) {
            BaseBinding binding = annotationParser.apply(annotation);
            if (binding == null) continue;
            this.log.debug((CharSequence)("Adding binding: " + binding.toString()));
            bindings.add(binding);
        }
        return bindings;
    }

    protected BaseBinding parseParameterAnnotation(Annotation annotation) {
        return BindingFactory.getBinding(annotation);
    }

    protected BaseBinding parseMethodAnnotation(Annotation annotation) {
        BaseBinding ret = this.parseParameterAnnotation(annotation);
        if (ret != null) {
            ret.setName("$return");
        }
        return ret;
    }

    protected void patchStorageBinding(Method method, List<BaseBinding> bindings) {
        Optional<Annotation> storageAccount = Arrays.stream(method.getAnnotations()).filter(a -> a instanceof StorageAccount).findFirst();
        if (storageAccount.isPresent()) {
            this.log.debug((CharSequence)"StorageAccount annotation found.");
            String connectionString = ((StorageAccount)storageAccount.get()).value();
            bindings.stream().forEach(b -> {
                StorageBaseBinding sb;
                if (b instanceof StorageBaseBinding && StringUtils.isEmpty((String)(sb = (StorageBaseBinding)b).getConnection())) {
                    sb.setConnection(connectionString);
                }
            });
        } else {
            this.log.debug((CharSequence)"No StorageAccount annotation found.");
        }
    }
}

