/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.function.configurations;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.microsoft.azure.maven.function.bindings.BaseBinding;
import com.microsoft.azure.maven.function.bindings.StorageBaseBinding;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.plexus.util.StringUtils;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class FunctionConfiguration {
    public static final String MULTIPLE_TRIGGER = "Only one trigger is allowed for each Azure Function. Multiple triggers found on method: ";
    public static final String HTTP_OUTPUT_NOT_ALLOWED = "HttpOutput binding is only allowed to use with HttpTrigger binding. HttpOutput binding found on method: ";
    public static final String STORAGE_CONNECTION_EMPTY = "Storage binding (blob/queue/table) must have non-empty connection. Invalid storage binding found on method: ";
    private String scriptFile;
    private String entryPoint;
    private List<BaseBinding> bindings = new ArrayList<BaseBinding>();
    private boolean disabled = false;

    @JsonGetter(value="scriptFile")
    public String getScriptFile() {
        return this.scriptFile;
    }

    @JsonGetter(value="entryPoint")
    public String getEntryPoint() {
        return this.entryPoint;
    }

    @JsonGetter(value="bindings")
    public List<BaseBinding> getBindings() {
        return this.bindings;
    }

    @JsonGetter(value="disabled")
    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public void setScriptFile(String scriptFile) {
        this.scriptFile = scriptFile;
    }

    public void setEntryPoint(String entryPoint) {
        this.entryPoint = entryPoint;
    }

    public void validate() {
        this.checkMultipleTrigger();
        this.checkHttpOutputBinding();
        this.checkEmptyStorageConnection();
    }

    protected void checkMultipleTrigger() {
        if (this.getBindings().stream().filter(b -> b.getType().endsWith("Trigger")).count() > 1L) {
            throw new RuntimeException(MULTIPLE_TRIGGER + this.getEntryPoint());
        }
    }

    protected void checkHttpOutputBinding() {
        if (this.getBindings().stream().noneMatch(b -> b.getType().equalsIgnoreCase("httpTrigger")) && this.getBindings().stream().anyMatch(b -> b.getType().equalsIgnoreCase("http"))) {
            throw new RuntimeException(HTTP_OUTPUT_NOT_ALLOWED + this.getEntryPoint());
        }
    }

    protected void checkEmptyStorageConnection() {
        if (this.getBindings().stream().filter(b -> b instanceof StorageBaseBinding).map(b -> (StorageBaseBinding)b).filter(sb -> StringUtils.isEmpty((String)sb.getConnection())).count() > 0L) {
            throw new RuntimeException(STORAGE_CONNECTION_EMPTY + this.getEntryPoint());
        }
    }
}

