/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.function.bindings;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.microsoft.azure.maven.function.bindings.BaseBinding;
import com.microsoft.azure.serverless.functions.annotation.ServiceBusQueueOutput;
import com.microsoft.azure.serverless.functions.annotation.ServiceBusQueueTrigger;
import com.microsoft.azure.serverless.functions.annotation.ServiceBusTopicOutput;
import com.microsoft.azure.serverless.functions.annotation.ServiceBusTopicTrigger;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class ServiceBusBinding
extends BaseBinding {
    public static final String SERVICE_BUS_TRIGGER = "serviceBusTrigger";
    public static final String SERVICE_BUS = "serviceBus";
    private String queueName = "";
    private String topicName = "";
    private String subscriptionName = "";
    private String connection = "";
    private String access = "";

    public ServiceBusBinding(ServiceBusQueueTrigger queueTrigger) {
        super(queueTrigger.name(), SERVICE_BUS_TRIGGER, "in", queueTrigger.dataType());
        this.queueName = queueTrigger.queueName();
        this.connection = queueTrigger.connection();
        this.access = queueTrigger.access().toString();
    }

    public ServiceBusBinding(ServiceBusTopicTrigger topicTrigger) {
        super(topicTrigger.name(), SERVICE_BUS_TRIGGER, "in", topicTrigger.dataType());
        this.topicName = topicTrigger.topicName();
        this.subscriptionName = topicTrigger.subscriptionName();
        this.connection = topicTrigger.connection();
        this.access = topicTrigger.access().toString();
    }

    public ServiceBusBinding(ServiceBusQueueOutput queueOutput) {
        super(queueOutput.name(), SERVICE_BUS, "out", queueOutput.dataType());
        this.queueName = queueOutput.queueName();
        this.connection = queueOutput.connection();
        this.access = queueOutput.access().toString();
    }

    public ServiceBusBinding(ServiceBusTopicOutput topicOutput) {
        super(topicOutput.name(), SERVICE_BUS, "out", topicOutput.dataType());
        this.topicName = topicOutput.topicName();
        this.subscriptionName = topicOutput.subscriptionName();
        this.connection = topicOutput.connection();
        this.access = topicOutput.access().toString();
    }

    @JsonGetter
    public String getQueueName() {
        return this.queueName;
    }

    @JsonGetter
    public String getTopicName() {
        return this.topicName;
    }

    @JsonGetter
    public String getSubscriptionName() {
        return this.subscriptionName;
    }

    @JsonGetter
    public String getAccess() {
        return this.access;
    }

    @JsonGetter
    public String getConnection() {
        return this.connection;
    }
}

