/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.function.bindings;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.microsoft.azure.maven.function.bindings.BaseBinding;
import com.microsoft.azure.serverless.functions.annotation.HttpOutput;
import com.microsoft.azure.serverless.functions.annotation.HttpTrigger;
import java.util.Locale;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class HttpBinding
extends BaseBinding {
    public static final String HTTP_TRIGGER = "httpTrigger";
    public static final String HTTP = "http";
    private String route = "";
    private String webHookType = "";
    private String authLevel = "";
    private String[] methods = new String[0];

    public HttpBinding(HttpTrigger httpTrigger) {
        super(httpTrigger.name(), HTTP_TRIGGER, "in", httpTrigger.dataType());
        this.route = httpTrigger.route();
        this.authLevel = httpTrigger.authLevel().toString().toLowerCase(Locale.ENGLISH);
        this.methods = httpTrigger.methods();
        this.webHookType = httpTrigger.webHookType();
    }

    public HttpBinding(HttpOutput httpOutput) {
        super(httpOutput.name(), HTTP, "out", httpOutput.dataType());
    }

    public HttpBinding() {
        super("$return", HTTP, "out", "");
    }

    @JsonGetter
    public String getRoute() {
        return this.route;
    }

    @JsonGetter
    public String getWebHookType() {
        return this.webHookType;
    }

    @JsonGetter
    public String getAuthLevel() {
        return this.authLevel;
    }

    @JsonGetter
    public String[] getMethods() {
        return (String[])this.methods.clone();
    }
}

