/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.function.bindings;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.microsoft.azure.maven.function.bindings.BaseBinding;
import com.microsoft.azure.serverless.functions.annotation.DocumentDBInput;
import com.microsoft.azure.serverless.functions.annotation.DocumentDBOutput;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class DocumentDBBinding
extends BaseBinding {
    public static final String DOCUMENT_DB = "documentdb";
    private String databaseName = "";
    private String collectionName = "";
    private String id = "";
    private String sqlQuery = "";
    private String connection = "";
    private boolean createIfNotExists = false;

    public DocumentDBBinding(DocumentDBInput dbInput) {
        super(dbInput.name(), DOCUMENT_DB, "in", dbInput.dataType());
        this.databaseName = dbInput.databaseName();
        this.collectionName = dbInput.collectionName();
        this.id = dbInput.id();
        this.sqlQuery = dbInput.sqlQuery();
        this.connection = dbInput.connection();
    }

    public DocumentDBBinding(DocumentDBOutput dbOutput) {
        super(dbOutput.name(), DOCUMENT_DB, "out", dbOutput.dataType());
        this.databaseName = dbOutput.databaseName();
        this.collectionName = dbOutput.collectionName();
        this.connection = dbOutput.connection();
        this.createIfNotExists = dbOutput.createIfNotExists();
    }

    @JsonGetter
    public String getDatabaseName() {
        return this.databaseName;
    }

    @JsonGetter
    public String getCollectionName() {
        return this.collectionName;
    }

    @JsonGetter
    public String getId() {
        return this.id;
    }

    @JsonGetter
    public String getSqlQuery() {
        return this.sqlQuery;
    }

    @JsonGetter
    public String getConnection() {
        return this.connection;
    }

    @JsonGetter
    public boolean isCreateIfNotExists() {
        return this.createIfNotExists;
    }
}

