/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.function.bindings;

import com.microsoft.azure.maven.function.bindings.ApiHubFileBinding;
import com.microsoft.azure.maven.function.bindings.BaseBinding;
import com.microsoft.azure.maven.function.bindings.BlobBinding;
import com.microsoft.azure.maven.function.bindings.DocumentDBBinding;
import com.microsoft.azure.maven.function.bindings.EventHubBinding;
import com.microsoft.azure.maven.function.bindings.HttpBinding;
import com.microsoft.azure.maven.function.bindings.MobileTableBinding;
import com.microsoft.azure.maven.function.bindings.NotificationHubBinding;
import com.microsoft.azure.maven.function.bindings.QueueBinding;
import com.microsoft.azure.maven.function.bindings.SendGridBinding;
import com.microsoft.azure.maven.function.bindings.ServiceBusBinding;
import com.microsoft.azure.maven.function.bindings.TableBinding;
import com.microsoft.azure.maven.function.bindings.TimerBinding;
import com.microsoft.azure.maven.function.bindings.TwilioBinding;
import com.microsoft.azure.serverless.functions.annotation.ApiHubFileInput;
import com.microsoft.azure.serverless.functions.annotation.ApiHubFileOutput;
import com.microsoft.azure.serverless.functions.annotation.ApiHubFileTrigger;
import com.microsoft.azure.serverless.functions.annotation.BlobInput;
import com.microsoft.azure.serverless.functions.annotation.BlobOutput;
import com.microsoft.azure.serverless.functions.annotation.BlobTrigger;
import com.microsoft.azure.serverless.functions.annotation.DocumentDBInput;
import com.microsoft.azure.serverless.functions.annotation.DocumentDBOutput;
import com.microsoft.azure.serverless.functions.annotation.EventHubOutput;
import com.microsoft.azure.serverless.functions.annotation.EventHubTrigger;
import com.microsoft.azure.serverless.functions.annotation.HttpOutput;
import com.microsoft.azure.serverless.functions.annotation.HttpTrigger;
import com.microsoft.azure.serverless.functions.annotation.MobileTableInput;
import com.microsoft.azure.serverless.functions.annotation.MobileTableOutput;
import com.microsoft.azure.serverless.functions.annotation.NotificationHubOutput;
import com.microsoft.azure.serverless.functions.annotation.QueueOutput;
import com.microsoft.azure.serverless.functions.annotation.QueueTrigger;
import com.microsoft.azure.serverless.functions.annotation.SendGridOutput;
import com.microsoft.azure.serverless.functions.annotation.ServiceBusQueueOutput;
import com.microsoft.azure.serverless.functions.annotation.ServiceBusQueueTrigger;
import com.microsoft.azure.serverless.functions.annotation.ServiceBusTopicOutput;
import com.microsoft.azure.serverless.functions.annotation.ServiceBusTopicTrigger;
import com.microsoft.azure.serverless.functions.annotation.TableInput;
import com.microsoft.azure.serverless.functions.annotation.TableOutput;
import com.microsoft.azure.serverless.functions.annotation.TimerTrigger;
import com.microsoft.azure.serverless.functions.annotation.TwilioSmsOutput;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class BindingFactory {
    private static Map<Class<? extends Annotation>, Class<? extends BaseBinding>> map = new ConcurrentHashMap<Class<? extends Annotation>, Class<? extends BaseBinding>>();

    public static BaseBinding getBinding(Annotation annotation) {
        Class<? extends Annotation> annotationType = annotation.annotationType();
        return map.containsKey(annotationType) ? BindingFactory.createNewInstance(map.get(annotationType), annotation) : null;
    }

    private static BaseBinding createNewInstance(Class<? extends BaseBinding> binding, Annotation annotation) {
        try {
            Class<? extends Annotation> annotationType = annotation.annotationType();
            Constructor<? extends BaseBinding> constructor = binding.getConstructor(annotationType);
            return constructor.newInstance(annotation);
        }
        catch (Exception exception) {
            return null;
        }
    }

    static {
        map.put(ApiHubFileTrigger.class, ApiHubFileBinding.class);
        map.put(ApiHubFileInput.class, ApiHubFileBinding.class);
        map.put(ApiHubFileOutput.class, ApiHubFileBinding.class);
        map.put(BlobTrigger.class, BlobBinding.class);
        map.put(BlobInput.class, BlobBinding.class);
        map.put(BlobOutput.class, BlobBinding.class);
        map.put(DocumentDBInput.class, DocumentDBBinding.class);
        map.put(DocumentDBOutput.class, DocumentDBBinding.class);
        map.put(EventHubTrigger.class, EventHubBinding.class);
        map.put(EventHubOutput.class, EventHubBinding.class);
        map.put(HttpTrigger.class, HttpBinding.class);
        map.put(HttpOutput.class, HttpBinding.class);
        map.put(MobileTableInput.class, MobileTableBinding.class);
        map.put(MobileTableOutput.class, MobileTableBinding.class);
        map.put(NotificationHubOutput.class, NotificationHubBinding.class);
        map.put(QueueTrigger.class, QueueBinding.class);
        map.put(QueueOutput.class, QueueBinding.class);
        map.put(SendGridOutput.class, SendGridBinding.class);
        map.put(ServiceBusQueueTrigger.class, ServiceBusBinding.class);
        map.put(ServiceBusTopicTrigger.class, ServiceBusBinding.class);
        map.put(ServiceBusQueueOutput.class, ServiceBusBinding.class);
        map.put(ServiceBusTopicOutput.class, ServiceBusBinding.class);
        map.put(TableInput.class, TableBinding.class);
        map.put(TableOutput.class, TableBinding.class);
        map.put(TimerTrigger.class, TimerBinding.class);
        map.put(TwilioSmsOutput.class, TwilioBinding.class);
    }
}

