/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.function;

import com.microsoft.azure.maven.function.AbstractFunctionMojo;
import java.io.File;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.SystemUtils;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="run")
public class RunMojo
extends AbstractFunctionMojo {
    public static final String STAGE_DIR_FOUND = "Azure Functions stage directory found at: ";
    public static final String STAGE_DIR_NOT_FOUND = "Stage directory not found. Please run mvn:package or azure-functions:package first.";
    public static final String RUNTIME_FOUND = "Azure Functions Core Tools found.";
    public static final String RUNTIME_NOT_FOUND = "Azure Functions Core Tools not found. Please run 'npm i -g azure-functions-core-tools@core' to install Azure Functions Core Tools first.";
    public static final String RUN_FUNCTIONS_FAILURE = "Failed to run Azure Functions. Please checkout console output.";
    public static final String START_RUN_FUNCTIONS = "Starting running Azure Functions...";
    public static final String WINDOWS_FUNCTION_RUN = "cd /D %s && func function run %s --no-interactive";
    public static final String LINUX_FUNCTION_RUN = "cd %s; func function run %s --no-interactive";
    public static final String WINDOWS_HOST_START = "cd /D %s && func host start";
    public static final String LINUX_HOST_START = "cd %s; func host start";
    @Parameter(property="functions.target")
    protected String targetFunction;
    @Parameter(property="functions.input")
    protected String functionInputString;
    @Parameter(property="functions.inputFile")
    protected File functionInputFile;

    public String getTargetFunction() {
        return this.targetFunction;
    }

    public String getInputString() {
        return this.functionInputString;
    }

    public File getInputFile() {
        return this.functionInputFile;
    }

    protected void doExecute() throws Exception {
        this.checkStageDirectoryExistence();
        this.checkRuntimeExistence();
        this.runFunctions();
    }

    protected void checkStageDirectoryExistence() throws Exception {
        this.runCommand(this.getCheckStageDirectoryCommand(), false, this.getDefaultValidReturnCodes(), STAGE_DIR_NOT_FOUND);
        this.info(STAGE_DIR_FOUND + this.getDeploymentStageDirectory());
    }

    protected void checkRuntimeExistence() throws Exception {
        this.runCommand(this.getCheckRuntimeCommand(), false, this.getDefaultValidReturnCodes(), RUNTIME_NOT_FOUND);
        this.info(RUNTIME_FOUND);
    }

    protected void runFunctions() throws Exception {
        this.info(START_RUN_FUNCTIONS);
        this.runCommand(this.getRunFunctionCommand(), true, this.getValidReturnCodes(), RUN_FUNCTIONS_FAILURE);
    }

    protected String[] getCheckStageDirectoryCommand() {
        String command = String.format(this.isWindows() ? "cd /D %s" : "cd %s", this.getDeploymentStageDirectory());
        return this.buildCommand(command);
    }

    protected String[] getCheckRuntimeCommand() {
        return this.buildCommand("func");
    }

    protected String[] getRunFunctionCommand() {
        return StringUtils.isEmpty((String)this.getTargetFunction()) ? this.getStartFunctionHostCommand() : this.getRunSingleFunctionCommand();
    }

    protected String[] getRunSingleFunctionCommand() {
        String command = String.format(this.getRunFunctionTemplate(), this.getDeploymentStageDirectory(), this.getTargetFunction());
        if (StringUtils.isNotEmpty((String)this.getInputString())) {
            command = command.concat(" -c ").concat(this.getInputString());
        } else if (this.getInputFile() != null) {
            command = command.concat(" -f ").concat(this.getInputFile().getAbsolutePath());
        }
        return this.buildCommand(command);
    }

    protected String getRunFunctionTemplate() {
        return this.isWindows() ? WINDOWS_FUNCTION_RUN : LINUX_FUNCTION_RUN;
    }

    protected String[] getStartFunctionHostCommand() {
        String command = String.format(this.getStartFunctionHostTemplate(), this.getDeploymentStageDirectory());
        return this.buildCommand(command);
    }

    protected String getStartFunctionHostTemplate() {
        return this.isWindows() ? WINDOWS_HOST_START : LINUX_HOST_START;
    }

    protected String[] buildCommand(String command) {
        String[] stringArray;
        if (this.isWindows()) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = "cmd.exe";
            stringArray2[1] = "/c";
            stringArray = stringArray2;
            stringArray2[2] = command;
        } else {
            String[] stringArray3 = new String[3];
            stringArray3[0] = "sh";
            stringArray3[1] = "-c";
            stringArray = stringArray3;
            stringArray3[2] = command;
        }
        return stringArray;
    }

    protected boolean isWindows() {
        return SystemUtils.IS_OS_WINDOWS;
    }

    protected List<Long> getDefaultValidReturnCodes() {
        return Arrays.asList(0L);
    }

    protected List<Long> getValidReturnCodes() {
        return this.isWindows() ? Arrays.asList(0L, 3221225786L) : Arrays.asList(0L, 130L);
    }

    protected void runCommand(String[] command, boolean showStdout, List<Long> validReturnCodes, String errorMessage) throws Exception {
        this.debug("Executing command: " + StringUtils.join((Object[])command, (String)" "));
        ProcessBuilder.Redirect redirect = this.getStdoutRedirect(showStdout);
        Process process = new ProcessBuilder(command).redirectOutput(redirect).redirectErrorStream(true).start();
        process.waitFor();
        this.handleExitValue(process.exitValue(), validReturnCodes, errorMessage, process.getInputStream());
    }

    protected ProcessBuilder.Redirect getStdoutRedirect(boolean showStdout) {
        return showStdout ? ProcessBuilder.Redirect.INHERIT : ProcessBuilder.Redirect.PIPE;
    }

    protected void handleExitValue(int exitValue, List<Long> validReturnCodes, String errorMessage, InputStream inputStream) throws Exception {
        this.debug("Process exit value: " + exitValue);
        if (!validReturnCodes.contains(Integer.toUnsignedLong(exitValue))) {
            this.showErrorIfAny(inputStream);
            this.error(errorMessage);
            throw new Exception(errorMessage);
        }
    }

    protected void showErrorIfAny(InputStream inputStream) throws Exception {
        if (inputStream != null) {
            String input = IOUtil.toString((InputStream)inputStream);
            this.error(StringUtils.strip((String)input, (String)"\n"));
        }
    }
}

