/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.function;

import com.microsoft.azure.management.appservice.FunctionApp;
import com.microsoft.azure.management.appservice.PricingTier;
import com.microsoft.azure.management.appservice.implementation.SiteInner;
import com.microsoft.azure.maven.appservice.PricingTierEnum;
import com.microsoft.azure.maven.function.AbstractFunctionMojo;
import com.microsoft.azure.maven.function.handlers.ArtifactHandler;
import com.microsoft.azure.maven.function.handlers.FTPArtifactHandlerImpl;
import com.microsoft.azure.maven.function.handlers.MSDeployArtifactHandlerImpl;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="deploy", defaultPhase=LifecyclePhase.DEPLOY)
public class DeployMojo
extends AbstractFunctionMojo {
    public static final String FUNCTION_DEPLOY_START = "Starting deploying to Function App ";
    public static final String FUNCTION_DEPLOY_SUCCESS = "Successfully deployed Function App at https://%s.azurewebsites.net";
    public static final String FUNCTION_APP_CREATE_START = "Target Function App does not exist. Creating a new Function App ...";
    public static final String FUNCTION_APP_CREATED = "Successfully created Function App ";
    public static final String FUNCTION_APP_UPDATE = "Updating Function App...";
    public static final String FUNCTION_APP_UPDATE_DONE = "Successfully updated Function App ";
    public static final String MS_DEPLOY = "msdeploy";
    public static final String FTP = "ftp";
    @Parameter(property="functions.pricingTier")
    protected PricingTierEnum pricingTier;
    @Parameter(property="functions.deploymentType", defaultValue="msdeploy")
    protected String deploymentType;

    public PricingTier getPricingTier() {
        return this.pricingTier == null ? null : this.pricingTier.toPricingTier();
    }

    public String getDeploymentType() {
        return StringUtils.isEmpty((String)this.deploymentType) ? MS_DEPLOY : this.deploymentType;
    }

    protected void doExecute() throws Exception {
        this.info(FUNCTION_DEPLOY_START + this.getAppName() + "...");
        this.createOrUpdateFunctionApp();
        this.getArtifactHandler().publish();
        this.info(String.format(FUNCTION_DEPLOY_SUCCESS, this.getAppName()));
    }

    protected void createOrUpdateFunctionApp() throws Exception {
        FunctionApp app = this.getFunctionApp();
        if (app == null) {
            this.createFunctionApp();
        } else {
            this.updateFunctionApp(app);
        }
    }

    protected void createFunctionApp() throws Exception {
        this.info(FUNCTION_APP_CREATE_START);
        FunctionApp.DefinitionStages.NewAppServicePlanWithGroup newAppServicePlanWithGroup = this.defineApp(this.getAppName(), this.getRegion());
        FunctionApp.DefinitionStages.WithCreate withCreate = this.configureResourceGroup(newAppServicePlanWithGroup, this.getResourceGroup());
        this.configurePricingTier(withCreate, this.getPricingTier());
        this.configureAppSettings(arg_0 -> ((FunctionApp.DefinitionStages.WithCreate)withCreate).withAppSettings(arg_0), this.getAppSettings());
        withCreate.create();
        this.info(FUNCTION_APP_CREATED + this.getAppName());
    }

    protected void updateFunctionApp(FunctionApp app) {
        this.info(FUNCTION_APP_UPDATE);
        ((SiteInner)app.inner()).withTags(null);
        FunctionApp.Update update = (FunctionApp.Update)app.update();
        this.configureAppSettings(arg_0 -> ((FunctionApp.Update)update).withAppSettings(arg_0), this.getAppSettings());
        update.apply();
        this.info(FUNCTION_APP_UPDATE_DONE + this.getAppName());
    }

    protected FunctionApp.DefinitionStages.NewAppServicePlanWithGroup defineApp(String appName, String region) throws Exception {
        return (FunctionApp.DefinitionStages.NewAppServicePlanWithGroup)((FunctionApp.DefinitionStages.Blank)this.getAzureClient().appServices().functionApps().define(appName)).withRegion(region);
    }

    protected FunctionApp.DefinitionStages.WithCreate configureResourceGroup(FunctionApp.DefinitionStages.NewAppServicePlanWithGroup newAppServicePlanWithGroup, String resourceGroup) throws Exception {
        return this.isResourceGroupExist(resourceGroup) ? newAppServicePlanWithGroup.withExistingResourceGroup(resourceGroup) : newAppServicePlanWithGroup.withNewResourceGroup(resourceGroup);
    }

    protected boolean isResourceGroupExist(String resourceGroup) throws Exception {
        return this.getAzureClient().resourceGroups().checkExistence(resourceGroup);
    }

    protected void configurePricingTier(FunctionApp.DefinitionStages.WithCreate withCreate, PricingTier pricingTier) {
        if (pricingTier != null) {
            withCreate.withNewAppServicePlan(pricingTier).withWebAppAlwaysOn(true);
        } else {
            withCreate.withNewConsumptionPlan();
        }
    }

    protected void configureAppSettings(Consumer<Map> withAppSettings, Map appSettings) {
        if (appSettings != null && !appSettings.isEmpty()) {
            withAppSettings.accept(appSettings);
        }
    }

    protected ArtifactHandler getArtifactHandler() {
        switch (this.getDeploymentType().toLowerCase(Locale.ENGLISH)) {
            case "ftp": {
                return new FTPArtifactHandlerImpl(this);
            }
        }
        return new MSDeployArtifactHandlerImpl(this);
    }
}

