/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.function;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.azure.maven.function.AbstractFunctionMojo;
import com.microsoft.azure.maven.function.template.FunctionTemplate;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Scanner;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.lang.model.SourceVersion;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="add")
public class AddMojo
extends AbstractFunctionMojo {
    public static final String LOAD_TEMPLATES = "Step 1 of 4: Load all function templates";
    public static final String LOAD_TEMPLATES_DONE = "Successfully loaded all function templates";
    public static final String LOAD_TEMPLATES_FAIL = "Failed to load all function templates.";
    public static final String FIND_TEMPLATE = "Step 2 of 4: Select function template";
    public static final String FIND_TEMPLATE_DONE = "Successfully found function template: ";
    public static final String FIND_TEMPLATE_FAIL = "Function template not found: ";
    public static final String PREPARE_PARAMS = "Step 3 of 4: Prepare required parameters";
    public static final String FOUND_VALID_VALUE = "Found valid value. Skip user input.";
    public static final String SAVE_FILE = "Step 4 of 4: Saving function to file";
    public static final String SAVE_FILE_DONE = "Successfully saved new function at ";
    public static final String FILE_EXIST = "Function already exists at %s. Please specify a different function name.";
    @Parameter(defaultValue="${project.basedir}", readonly=true, required=true)
    protected File basedir;
    @Parameter(defaultValue="${project.compileSourceRoots}", readonly=true, required=true)
    protected List<String> compileSourceRoots;
    @Parameter(property="functions.package")
    protected String functionPackageName;
    @Parameter(property="functions.name")
    protected String functionName;
    @Parameter(property="functions.template")
    protected String functionTemplate;

    public String getFunctionPackageName() {
        return this.functionPackageName;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public String getFunctionTemplate() {
        return this.functionTemplate;
    }

    protected String getBasedir() {
        return this.basedir.getAbsolutePath();
    }

    protected String getSourceRoot() {
        return this.compileSourceRoots == null || this.compileSourceRoots.isEmpty() ? Paths.get(this.getBasedir(), "src", "main", "java").toString() : this.compileSourceRoots.get(0);
    }

    protected void setFunctionPackageName(String functionPackageName) {
        this.functionPackageName = StringUtils.lowerCase((String)functionPackageName);
    }

    protected void setFunctionName(String functionName) {
        this.functionName = StringUtils.capitalise((String)functionName);
    }

    protected void setFunctionTemplate(String functionTemplate) {
        this.functionTemplate = functionTemplate;
    }

    protected void doExecute() throws Exception {
        List<FunctionTemplate> templates = this.loadAllFunctionTemplates();
        FunctionTemplate template = this.getFunctionTemplate(templates);
        Map<String, String> params = this.prepareRequiredParameters(template);
        String newFunctionClass = this.substituteParametersInTemplate(template, params);
        this.saveNewFunctionToFile(newFunctionClass);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List<FunctionTemplate> loadAllFunctionTemplates() throws Exception {
        this.info("");
        this.info(LOAD_TEMPLATES);
        try (InputStream is = AddMojo.class.getResourceAsStream("/templates.json");){
            String templatesJsonStr = IOUtil.toString((InputStream)is);
            List<FunctionTemplate> templates = this.parseTemplateJson(templatesJsonStr);
            this.info(LOAD_TEMPLATES_DONE);
            List<FunctionTemplate> list = templates;
            return list;
        }
        catch (Exception e) {
            this.error(LOAD_TEMPLATES_FAIL);
            throw e;
        }
    }

    protected List<FunctionTemplate> parseTemplateJson(String templateJson) throws Exception {
        FunctionTemplate[] templates = (FunctionTemplate[])new ObjectMapper().readValue(templateJson, FunctionTemplate[].class);
        return Arrays.asList(templates);
    }

    protected FunctionTemplate getFunctionTemplate(List<FunctionTemplate> templates) throws Exception {
        this.info("");
        this.info(FIND_TEMPLATE);
        this.assureInputFromUser("template for new function", this.getFunctionTemplate(), this.getTemplateNames(templates), this::setFunctionTemplate);
        return this.findTemplateByName(templates, this.getFunctionTemplate());
    }

    protected List<String> getTemplateNames(List<FunctionTemplate> templates) {
        return templates.stream().map(t -> t.getMetadata().getName()).collect(Collectors.toList());
    }

    protected FunctionTemplate findTemplateByName(List<FunctionTemplate> templates, String templateName) throws Exception {
        this.info("Selected function template: " + templateName);
        Optional<FunctionTemplate> template = templates.stream().filter(t -> t.getMetadata().getName().equalsIgnoreCase(templateName)).findFirst();
        if (template.isPresent()) {
            this.info(FIND_TEMPLATE_DONE + templateName);
            return template.get();
        }
        throw new Exception(FIND_TEMPLATE_FAIL + templateName);
    }

    protected Map<String, String> prepareRequiredParameters(FunctionTemplate template) {
        this.info("");
        this.info(PREPARE_PARAMS);
        this.prepareFunctionName();
        this.preparePackageName();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("functionName", this.getFunctionName());
        params.put("packageName", this.getFunctionPackageName());
        this.prepareTemplateParameters(template, params);
        this.displayParameters(params);
        return params;
    }

    protected void prepareFunctionName() {
        this.info("Common parameter [Function Name]: name for both the new function and Java class");
        this.assureInputFromUser("Enter value for Function Name: ", this.getFunctionName(), str -> StringUtils.isNotEmpty((String)str) && SourceVersion.isIdentifier(str) && !SourceVersion.isKeyword(str), "Input should be a valid Java class name.", this::setFunctionName);
    }

    protected void preparePackageName() {
        this.info("Common parameter [Package Name]: package name of the new Java class");
        this.assureInputFromUser("Enter value for Package Name: ", this.getFunctionPackageName(), str -> StringUtils.isNotEmpty((String)str) && SourceVersion.isName(str), "Input should be a valid Java package name.", this::setFunctionPackageName);
    }

    protected Map<String, String> prepareTemplateParameters(FunctionTemplate template, Map<String, String> params) {
        for (String property : template.getMetadata().getUserPrompt()) {
            this.info(String.format("Trigger specific parameter [%s]", property));
            this.assureInputFromUser(String.format("Enter value for %s: ", property), null, str -> StringUtils.isNotEmpty((String)str), "Input should be a non-empty string.", str -> params.put(property, (String)str));
        }
        return params;
    }

    protected void displayParameters(Map<String, String> params) {
        this.info("");
        this.info("Summary of parameters for function template:");
        params.entrySet().stream().forEach(e -> this.info(String.format("%s: %s", e.getKey(), e.getValue())));
    }

    protected String substituteParametersInTemplate(FunctionTemplate template, Map<String, String> params) {
        String ret = template.getFiles().get("function.java");
        for (Map.Entry<String, String> entry : params.entrySet()) {
            ret = ret.replace(String.format("$%s$", entry.getKey()), entry.getValue());
        }
        return ret;
    }

    protected void saveNewFunctionToFile(String newFunctionClass) throws Exception {
        this.info("");
        this.info(SAVE_FILE);
        File packageDir = this.getPackageDir();
        File targetFile = this.getTargetFile(packageDir);
        this.createPackageDirIfNotExist(packageDir);
        this.saveToTargetFile(targetFile, newFunctionClass);
        this.info(SAVE_FILE_DONE + targetFile.getAbsolutePath());
    }

    protected File getPackageDir() {
        String sourceRoot = this.getSourceRoot();
        String[] packageName = this.getFunctionPackageName().split("\\.");
        return Paths.get(sourceRoot, packageName).toFile();
    }

    protected File getTargetFile(File packageDir) throws Exception {
        String functionName = this.getFunctionName() + ".java";
        File targetFile = new File(packageDir, functionName);
        if (targetFile.exists()) {
            throw new FileAlreadyExistsException(String.format(FILE_EXIST, targetFile.getAbsolutePath()));
        }
        return targetFile;
    }

    protected void createPackageDirIfNotExist(File packageDir) {
        if (!packageDir.exists()) {
            packageDir.mkdirs();
        }
    }

    protected void saveToTargetFile(File targetFile, String newFunctionClass) throws Exception {
        try (FileOutputStream os = new FileOutputStream(targetFile);){
            IOUtil.copy((String)newFunctionClass, (OutputStream)os);
        }
    }

    protected void assureInputFromUser(String prompt, String initValue, List<String> options, Consumer<String> setter) {
        if (options.stream().anyMatch(o -> o.equalsIgnoreCase(initValue))) {
            this.info(FOUND_VALID_VALUE);
            return;
        }
        System.out.printf("Choose from below options as %s.%n", prompt);
        for (int i = 0; i < options.size(); ++i) {
            System.out.printf("%d. %s%n", i, options.get(i));
        }
        this.assureInputFromUser("Enter index to use: ", null, str -> {
            try {
                int index = Integer.parseInt(str);
                return 0 <= index && index < options.size();
            }
            catch (Exception e) {
                return false;
            }
        }, "Invalid index.", str -> {
            int index = Integer.parseInt(str);
            setter.accept((String)options.get(index));
        });
    }

    protected void assureInputFromUser(String prompt, String initValue, Function<String, Boolean> validator, String errorMessage, Consumer<String> setter) {
        if (validator.apply(initValue).booleanValue()) {
            this.info(FOUND_VALID_VALUE);
            setter.accept(initValue);
            return;
        }
        Scanner scanner = this.getScanner();
        while (true) {
            System.out.printf(prompt, new Object[0]);
            System.out.flush();
            try {
                String input = scanner.nextLine();
                if (validator.apply(input).booleanValue()) {
                    setter.accept(input);
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.warning(errorMessage);
        }
    }

    protected Scanner getScanner() {
        return new Scanner(System.in, "UTF-8");
    }
}

