/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.function;

import com.microsoft.azure.management.appservice.FunctionApp;
import com.microsoft.azure.maven.AbstractAzureMojo;
import com.microsoft.azure.maven.auth.AzureAuthFailureException;
import java.io.File;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class AbstractFunctionMojo
extends AbstractAzureMojo {
    public static final String AZURE_FUNCTIONS = "azure-functions";
    @Parameter(defaultValue="${project.build.finalName}", readonly=true, required=true)
    protected String finalName;
    @Parameter(defaultValue="${project.build.outputDirectory}", readonly=true, required=true)
    protected File outputDirectory;
    @Parameter(property="functions.resourceGroup", required=true)
    protected String resourceGroup;
    @Parameter(property="functions.appName", required=true)
    protected String appName;
    @Parameter(property="functions.region", defaultValue="westus")
    protected String region;
    @Parameter
    protected Properties appSettings;
    @Parameter(property="functions.skip", defaultValue="false")
    protected boolean skip;

    protected boolean isSkipMojo() {
        return this.skip;
    }

    public String getFinalName() {
        return this.finalName;
    }

    public String getResourceGroup() {
        return this.resourceGroup;
    }

    public String getAppName() {
        return this.appName;
    }

    public String getRegion() {
        return this.region;
    }

    public Map getAppSettings() {
        return this.appSettings;
    }

    public String getDeploymentStageDirectory() {
        return Paths.get(this.getBuildDirectoryAbsolutePath(), AZURE_FUNCTIONS, this.getAppName()).toString();
    }

    public FunctionApp getFunctionApp() throws AzureAuthFailureException {
        try {
            return (FunctionApp)this.getAzureClient().appServices().functionApps().getByResourceGroup(this.getResourceGroup(), this.getAppName());
        }
        catch (AzureAuthFailureException authEx) {
            throw authEx;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

