/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.plugin.functions.gradle.util;

import com.microsoft.azure.plugin.functions.gradle.JavaProject;
import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.BasePluginConvention;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;

public class GradleProjectUtils {
    private static final String MAIN_SOURCE_SET_NAME = "main";
    private static final String DEPENDENCY_WARNING = "The following dependencies could not be found, please check whether related modules have been packaged \n %s";

    public static JavaProject convert(Project project) {
        JavaPluginConvention javaPluginConvention = (JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class);
        Objects.requireNonNull(javaPluginConvention, "Project " + project.getName() + " is not java project.");
        SourceSet mainSourceSet = (SourceSet)javaPluginConvention.getSourceSets().getByName(MAIN_SOURCE_SET_NAME);
        FileCollection classesOutputDirectories = mainSourceSet.getOutput().getClassesDirs().filter(File::exists);
        Path resourcesOutputDirectory = Objects.requireNonNull(mainSourceSet.getOutput().getResourcesDir()).toPath();
        FileCollection allFiles = mainSourceSet.getRuntimeClasspath();
        FileCollection allDependencies = allFiles.minus(classesOutputDirectories).filter(file -> !file.toPath().equals(resourcesOutputDirectory));
        JavaProject func = new JavaProject();
        func.setBaseDirectory(project.getProjectDir().toPath());
        func.setBuildDirectory(project.getBuildDir().toPath());
        List<Path> dependencies = allDependencies.getFiles().stream().filter(File::exists).map(File::toPath).collect(Collectors.toList());
        List nonExistDependencies = allDependencies.getFiles().stream().filter(file -> !file.exists()).map(File::getPath).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(nonExistDependencies)) {
            AzureMessager.getMessager().warning(AzureString.format((String)DEPENDENCY_WARNING, (Object[])new Object[]{String.join((CharSequence)"\n", "\t" + nonExistDependencies)}));
        }
        func.setDependencies(dependencies);
        BasePluginConvention basePlugin = (BasePluginConvention)project.getConvention().getPlugin(BasePluginConvention.class);
        func.setArtifactFile(Paths.get(project.getBuildDir().getAbsolutePath(), basePlugin.getLibsDirName(), basePlugin.getArchivesBaseName() + "-" + project.getVersion() + ".jar"));
        return func;
    }
}

