/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.plugin.functions.gradle.handler;

import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.microsoft.azure.gradle.temeletry.TelemetryAgent;
import com.microsoft.azure.toolkit.lib.common.IProject;
import com.microsoft.azure.toolkit.lib.common.exception.AzureExecutionException;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.legacy.function.bindings.Binding;
import com.microsoft.azure.toolkit.lib.legacy.function.bindings.BindingEnum;
import com.microsoft.azure.toolkit.lib.legacy.function.configurations.FunctionConfiguration;
import com.microsoft.azure.toolkit.lib.legacy.function.handlers.AnnotationHandler;
import com.microsoft.azure.toolkit.lib.legacy.function.handlers.AnnotationHandlerImpl;
import com.microsoft.azure.toolkit.lib.legacy.function.handlers.CommandHandler;
import com.microsoft.azure.toolkit.lib.legacy.function.handlers.CommandHandlerImpl;
import com.microsoft.azure.toolkit.lib.legacy.function.handlers.FunctionCoreToolsHandler;
import com.microsoft.azure.toolkit.lib.legacy.function.handlers.FunctionCoreToolsHandlerImpl;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageHandler {
    private static final Logger log = LoggerFactory.getLogger(PackageHandler.class);
    public static final String HOST_JSON = "host.json";
    public static final String LOCAL_SETTINGS_JSON = "local.settings.json";
    private static final String LINE_FEED = "\r\n";
    private static final String DOCS_LINK = "https://aka.ms/functions-local-settings";
    private static final String SEARCH_FUNCTIONS = "Step 1 of 8: Searching for Azure Functions entry points";
    private static final String FOUND_FUNCTIONS = " Azure Functions entry point(s) found.";
    private static final String NO_FUNCTIONS = "Azure Functions entry point not found, plugin will exit.";
    private static final String GENERATE_CONFIG = "Step 2 of 8: Generating Azure Functions configurations";
    private static final String GENERATE_SKIP = "No Azure Functions found. Skip configuration generation.";
    private static final String GENERATE_DONE = "Generation done.";
    private static final String VALIDATE_CONFIG = "Step 3 of 8: Validating generated configurations";
    private static final String VALIDATE_SKIP = "No configurations found. Skip validation.";
    private static final String VALIDATE_DONE = "Validation done.";
    private static final String SAVE_HOST_JSON = "Step 4 of 8: Saving host.json";
    private static final String SAVE_LOCAL_SETTINGS_JSON = "Step 5 of 8: Saving local.settings.json";
    private static final String SAVE_FUNCTION_JSONS = "Step 6 of 8: Saving configurations to function.json";
    private static final String SAVE_SKIP = "No configurations found. Skip save.";
    private static final String SAVE_FUNCTION_JSON = "Starting processing function: ";
    private static final String SAVE_SUCCESS = "Successfully saved to ";
    private static final String COPY_JARS = "Step 7 of 8: Copying JARs to staging directory: ";
    private static final String COPY_SUCCESS = "Copied successfully.";
    private static final String INSTALL_EXTENSIONS = "Step 8 of 8: Installing function extensions if needed";
    private static final String SKIP_INSTALL_EXTENSIONS_HTTP = "Skip install Function extension for HTTP Trigger Functions";
    private static final String INSTALL_EXTENSIONS_FINISH = "Function extension installation done.";
    private static final String BUILD_SUCCESS = "Successfully built Azure Functions.";
    private static final String FUNCTION_JSON = "function.json";
    private static final String EXTENSION_BUNDLE = "extensionBundle";
    private static final String AZURE_FUNCTIONS_JAVA_LIBRARY = "azure-functions-java-library";
    private static final String AZURE_FUNCTIONS_JAVA_CORE_LIBRARY = "azure-functions-java-core-library";
    private static final BindingEnum[] FUNCTION_WITHOUT_FUNCTION_EXTENSION = new BindingEnum[]{BindingEnum.HttpOutput, BindingEnum.HttpTrigger};
    private static final String EXTENSION_BUNDLE_ID = "Microsoft.Azure.Functions.ExtensionBundle";
    private static final String EXTENSION_BUNDLE_PREVIEW_ID = "Microsoft.Azure.Functions.ExtensionBundle.Preview";
    private static final String SKIP_INSTALL_EXTENSIONS_BUNDLE = "Extension bundle specified, skip install extension";
    private static final String DEFAULT_LOCAL_SETTINGS_JSON = "{ \"IsEncrypted\": false, \"Values\": { \"FUNCTIONS_WORKER_RUNTIME\": \"java\" } }";
    private static final String DEFAULT_HOST_JSON = "{\"version\":\"2.0\",\"extensionBundle\":{\"id\":\"Microsoft.Azure.Functions.ExtensionBundle\",\"version\":\"[3.*, 4.0.0)\"}}\n";
    private static final String TRIGGER_TYPE = "triggerType";
    private static final Pattern ARTIFACT_NAME_PATTERN = Pattern.compile("(.*)-(\\d+\\.)?(\\d+\\.)?(\\*|\\d+).*");
    private final IProject project;
    private final String deploymentStagingDirectoryPath;

    public PackageHandler(IProject project, String deploymentStagingDirectoryPath) {
        Preconditions.checkNotNull((Object)project);
        Preconditions.checkNotNull((Object)deploymentStagingDirectoryPath);
        Preconditions.checkArgument((!new File(deploymentStagingDirectoryPath).isFile() ? 1 : 0) != 0);
        this.deploymentStagingDirectoryPath = deploymentStagingDirectoryPath;
        this.project = project;
    }

    public void execute() throws AzureExecutionException, IOException {
        AnnotationHandler annotationHandler = this.getAnnotationHandler();
        Set<Method> methods = this.findAnnotatedMethods(annotationHandler);
        if (methods.size() == 0) {
            throw new AzureExecutionException(NO_FUNCTIONS);
        }
        Map<String, FunctionConfiguration> configMap = this.getFunctionConfigurations(annotationHandler, methods);
        this.validateFunctionConfigurations(configMap);
        this.copyHostJsonFile();
        this.copyLocalSettingJsonFile();
        this.writeFunctionJsonFiles(this.getObjectWriter(), configMap);
        this.copyJarsToStageDirectory();
        CommandHandlerImpl commandHandler = new CommandHandlerImpl();
        FunctionCoreToolsHandler functionCoreToolsHandler = this.getFunctionCoreToolsHandler((CommandHandler)commandHandler);
        Set<BindingEnum> bindingClasses = this.getFunctionBindingEnums(configMap);
        this.installExtension(functionCoreToolsHandler, bindingClasses);
        AzureMessager.getMessager().info(BUILD_SUCCESS);
    }

    private AnnotationHandler getAnnotationHandler() {
        return new AnnotationHandlerImpl();
    }

    private Set<Method> findAnnotatedMethods(AnnotationHandler handler) throws MalformedURLException {
        Set functions;
        AzureMessager.getMessager().info("\r\nStep 1 of 8: Searching for Azure Functions entry points");
        try {
            log.debug("ClassPath to resolve: " + this.getArtifactFileUrl());
            List<URL> dependencyWithTargetClass = this.getDependencyArtifactUrls();
            dependencyWithTargetClass.add(this.getArtifactFileUrl());
            functions = handler.findFunctions(dependencyWithTargetClass);
        }
        catch (NoClassDefFoundError e) {
            log.debug("ClassPath to resolve: " + this.getArtifactUrl());
            functions = handler.findFunctions(Collections.singletonList(this.getArtifactUrl()));
        }
        AzureMessager.getMessager().info(functions.size() + FOUND_FUNCTIONS);
        return functions;
    }

    private URL getArtifactUrl() throws MalformedURLException {
        return this.project.getArtifactFile().toFile().toURI().toURL();
    }

    private URL getArtifactFileUrl() throws MalformedURLException {
        return this.project.getArtifactFile().toFile().toURI().toURL();
    }

    private List<URL> getDependencyArtifactUrls() {
        ArrayList<URL> urlList = new ArrayList<URL>();
        for (Path jarFilePath : this.project.getProjectDependencies()) {
            File f = jarFilePath.toFile();
            try {
                urlList.add(f.toURI().toURL());
            }
            catch (MalformedURLException e) {
                log.debug("Failed to get URL for file: " + f);
            }
        }
        return urlList;
    }

    private Map<String, FunctionConfiguration> getFunctionConfigurations(AnnotationHandler handler, Set<Method> methods) throws AzureExecutionException {
        AzureMessager.getMessager().info("\r\nStep 2 of 8: Generating Azure Functions configurations");
        Map configMap = handler.generateConfigurations(methods);
        if (configMap.size() == 0) {
            AzureMessager.getMessager().info(GENERATE_SKIP);
        } else {
            String scriptFilePath = this.getScriptFilePath();
            configMap.values().forEach(config -> config.setScriptFile(scriptFilePath));
            AzureMessager.getMessager().info(GENERATE_DONE);
        }
        return configMap;
    }

    private String getScriptFilePath() {
        return "../" + this.project.getArtifactFile().getFileName().toString();
    }

    private void validateFunctionConfigurations(Map<String, FunctionConfiguration> configMap) {
        AzureMessager.getMessager().info("\r\nStep 3 of 8: Validating generated configurations");
        if (configMap.size() == 0) {
            AzureMessager.getMessager().info(VALIDATE_SKIP);
        } else {
            configMap.values().forEach(FunctionConfiguration::validate);
            AzureMessager.getMessager().info(VALIDATE_DONE);
        }
        this.trackFunctionProperties(configMap);
    }

    private void writeFunctionJsonFiles(ObjectWriter objectWriter, Map<String, FunctionConfiguration> configMap) throws IOException {
        AzureMessager.getMessager().info("\r\nStep 6 of 8: Saving configurations to function.json");
        if (configMap.size() == 0) {
            AzureMessager.getMessager().info(SAVE_SKIP);
        } else {
            for (Map.Entry<String, FunctionConfiguration> config : configMap.entrySet()) {
                this.writeFunctionJsonFile(objectWriter, config.getKey(), config.getValue());
            }
        }
    }

    private void writeFunctionJsonFile(ObjectWriter objectWriter, String functionName, FunctionConfiguration config) throws IOException {
        AzureMessager.getMessager().info(SAVE_FUNCTION_JSON + functionName);
        File functionJsonFile = Paths.get(this.deploymentStagingDirectoryPath, functionName, FUNCTION_JSON).toFile();
        this.writeObjectToFile(objectWriter, config, functionJsonFile);
        AzureMessager.getMessager().info(SAVE_SUCCESS + functionJsonFile.getAbsolutePath());
    }

    private void copyHostJsonFile() throws IOException {
        AzureMessager.getMessager().info("\r\nStep 4 of 8: Saving host.json");
        File sourceHostJsonFile = new File(this.project.getBaseDirectory().toFile(), HOST_JSON);
        File hostJsonFile = Paths.get(this.deploymentStagingDirectoryPath, HOST_JSON).toFile();
        PackageHandler.copyFilesWithDefaultContent(sourceHostJsonFile, hostJsonFile, DEFAULT_HOST_JSON);
        AzureMessager.getMessager().info(SAVE_SUCCESS + hostJsonFile.getAbsolutePath());
    }

    private void copyLocalSettingJsonFile() throws AzureExecutionException, IOException {
        AzureMessager.getMessager().info("\r\nStep 5 of 8: Saving local.settings.json");
        File localSettingJsonTargetFile = Paths.get(this.deploymentStagingDirectoryPath, LOCAL_SETTINGS_JSON).toFile();
        File localSettingJsonSrcFile = new File(this.project.getBaseDirectory().toFile(), LOCAL_SETTINGS_JSON);
        if (localSettingJsonSrcFile.exists() && localSettingJsonSrcFile.length() == 0L) {
            throw new AzureExecutionException("The " + localSettingJsonSrcFile.getAbsolutePath() + " file is empty, please check the document at" + DOCS_LINK);
        }
        PackageHandler.copyFilesWithDefaultContent(localSettingJsonSrcFile, localSettingJsonTargetFile, DEFAULT_LOCAL_SETTINGS_JSON);
        AzureMessager.getMessager().info(SAVE_SUCCESS + localSettingJsonTargetFile.getAbsolutePath());
    }

    private static void copyFilesWithDefaultContent(File src, File dest, String defaultContent) throws IOException {
        if (src.exists()) {
            FileUtils.copyFile((File)src, (File)dest);
        } else {
            FileUtils.write((File)dest, (CharSequence)StringUtils.firstNonBlank((CharSequence[])new String[]{defaultContent, ""}), (Charset)Charset.defaultCharset());
        }
    }

    private void writeObjectToFile(ObjectWriter objectWriter, Object object, File targetFile) throws IOException {
        if (!targetFile.getParentFile().mkdirs()) {
            throw new AzureToolkitRuntimeException("Cannot create folder: " + targetFile.getParentFile().getAbsolutePath());
        }
        targetFile.createNewFile();
        objectWriter.writeValue(targetFile, object);
    }

    private ObjectWriter getObjectWriter() {
        DefaultIndenter indenter = DefaultIndenter.SYSTEM_LINEFEED_INSTANCE.withLinefeed("\n");
        DefaultPrettyPrinter prettyPrinter = new DefaultPrettyPrinter().withObjectIndenter((DefaultPrettyPrinter.Indenter)indenter);
        return new ObjectMapper().configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false).writer((PrettyPrinter)prettyPrinter);
    }

    private void copyJarsToStageDirectory() throws IOException {
        AzureMessager.getMessager().info("\r\nStep 7 of 8: Copying JARs to staging directory: " + this.deploymentStagingDirectoryPath);
        File libFolder = new File(this.deploymentStagingDirectoryPath, "lib");
        if (libFolder.exists()) {
            FileUtils.cleanDirectory((File)libFolder);
        }
        List artifacts = this.project.getProjectDependencies().stream().map(Path::toFile).collect(Collectors.toList());
        String libraryToExclude = artifacts.stream().map(PackageHandler::getArtifactIdFromFile).filter(name -> StringUtils.equalsAnyIgnoreCase((CharSequence)name, (CharSequence[])new CharSequence[]{AZURE_FUNCTIONS_JAVA_CORE_LIBRARY})).findFirst().orElse(AZURE_FUNCTIONS_JAVA_LIBRARY);
        for (File file : artifacts) {
            if (StringUtils.equalsIgnoreCase((CharSequence)PackageHandler.getArtifactIdFromFile(file), (CharSequence)libraryToExclude)) continue;
            if (!file.exists()) {
                throw new AzureToolkitRuntimeException(String.format("Dependency artifact (%s) not found, please correct the dependency and try again", file.getAbsolutePath()));
            }
            FileUtils.copyFileToDirectory((File)file, (File)libFolder);
        }
        FileUtils.copyFileToDirectory((File)this.project.getArtifactFile().toFile(), (File)new File(this.deploymentStagingDirectoryPath));
        AzureMessager.getMessager().info(COPY_SUCCESS);
    }

    private static String getArtifactIdFromFile(@Nonnull File file) {
        Matcher matcher = ARTIFACT_NAME_PATTERN.matcher(file.getName());
        return matcher.matches() ? StringUtils.substringBeforeLast((String)file.getName(), (String)"-") : StringUtils.substringBeforeLast((String)file.getName(), (String)".jar");
    }

    private FunctionCoreToolsHandler getFunctionCoreToolsHandler(CommandHandler commandHandler) {
        return new FunctionCoreToolsHandlerImpl(commandHandler);
    }

    private void installExtension(FunctionCoreToolsHandler handler, Set<BindingEnum> bindingEnums) throws AzureExecutionException {
        AzureMessager.getMessager().info("\r\nStep 8 of 8: Installing function extensions if needed");
        if (!this.isInstallingExtensionNeeded(bindingEnums)) {
            return;
        }
        handler.installExtension(new File(this.deploymentStagingDirectoryPath), this.project.getBaseDirectory().toFile());
        AzureMessager.getMessager().info(INSTALL_EXTENSIONS_FINISH);
    }

    private Set<BindingEnum> getFunctionBindingEnums(Map<String, FunctionConfiguration> configMap) {
        HashSet<BindingEnum> result = new HashSet<BindingEnum>();
        configMap.values().forEach(configuration -> configuration.getBindings().forEach(binding -> result.add(binding.getBindingEnum())));
        return result;
    }

    private boolean isInstallingExtensionNeeded(Set<BindingEnum> bindingTypes) {
        JsonObject hostJson = this.readHostJson();
        String extensionBundleId = Optional.ofNullable(hostJson).map(host -> host.getAsJsonObject(EXTENSION_BUNDLE)).map(extensionBundle -> extensionBundle.get("id")).map(JsonElement::getAsString).orElse(null);
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)extensionBundleId, (CharSequence[])new CharSequence[]{EXTENSION_BUNDLE_ID, EXTENSION_BUNDLE_PREVIEW_ID})) {
            AzureMessager.getMessager().info(SKIP_INSTALL_EXTENSIONS_BUNDLE);
            return false;
        }
        boolean isNonHttpTriggersExist = bindingTypes.stream().anyMatch(binding -> !Arrays.asList(FUNCTION_WITHOUT_FUNCTION_EXTENSION).contains(binding));
        if (!isNonHttpTriggersExist) {
            AzureMessager.getMessager().info(SKIP_INSTALL_EXTENSIONS_HTTP);
            return false;
        }
        return true;
    }

    /*
     * Exception decompiling
     */
    private JsonObject readHostJson() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void trackFunctionProperties(Map<String, FunctionConfiguration> configMap) {
        List bindingTypeSet = configMap.values().stream().flatMap(configuration -> configuration.getBindings().stream()).map(Binding::getType).sorted().distinct().collect(Collectors.toList());
        TelemetryAgent.getInstance().addDefaultProperty(TRIGGER_TYPE, StringUtils.join(bindingTypeSet, (String)","));
    }
}

