/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.plugin.functions.gradle;

import com.azure.core.http.policy.HttpLogDetailLevel;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.dataformat.javaprop.JavaPropsMapper;
import com.microsoft.azure.gradle.common.GradleAzureTaskManager;
import com.microsoft.azure.gradle.temeletry.TelemetryAgent;
import com.microsoft.azure.gradle.util.GradleAzureMessager;
import com.microsoft.azure.plugin.functions.gradle.AzureFunctionsExtension;
import com.microsoft.azure.plugin.functions.gradle.task.DeployTask;
import com.microsoft.azure.plugin.functions.gradle.task.LocalRunTask;
import com.microsoft.azure.plugin.functions.gradle.task.PackageTask;
import com.microsoft.azure.plugin.functions.gradle.task.PackageZipTask;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.cache.CacheManager;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.messager.IAzureMessager;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.common.task.AzureTaskManager;
import com.microsoft.azure.toolkit.lib.common.utils.Utils;
import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;

public class AzureFunctionsPlugin
implements Plugin<Project> {
    public static final String GRADLE_PLUGIN_NAME = "azure-functions-gradle-plugin";
    private static final String GRADLE_FUNCTION_EXTENSION = "azurefunctions";
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @AzureOperation(name="internal/functionapp.init_gradle_plugin")
    public void apply(Project project) {
        Project project2 = project;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)project2);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            AzureTaskManager.register((AzureTaskManager)new GradleAzureTaskManager());
            AzureMessager.setDefaultMessager((IAzureMessager)new GradleAzureMessager(project.getLogger()));
            AzureFunctionsExtension extension = (AzureFunctionsExtension)project.getExtensions().create(GRADLE_FUNCTION_EXTENSION, AzureFunctionsExtension.class, new Object[]{project});
            TelemetryAgent.getInstance().initTelemetry(GRADLE_PLUGIN_NAME, (String)StringUtils.firstNonBlank((CharSequence[])new String[]{AzureFunctionsPlugin.class.getPackage().getImplementationVersion(), "develop"}), BooleanUtils.isNotFalse((Boolean)extension.getAllowTelemetry()));
            TelemetryAgent.getInstance().showPrivacyStatement();
            try {
                CacheManager.evictCache((String)"<ALL>", (String)"<ALL>");
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
            Azure.az().config().setLogLevel(HttpLogDetailLevel.NONE.name());
            Azure.az().config().setUserAgent(TelemetryAgent.getInstance().getUserAgent());
            TaskContainer tasks = project.getTasks();
            TaskProvider packageTask = tasks.register("azureFunctionsPackage", PackageTask.class, task -> {
                task.setGroup("AzureFunctions");
                task.setDescription("Package current project to staging folder.");
                task.setFunctionsExtension(extension);
            });
            TaskProvider packageZipTask = tasks.register("azureFunctionsPackageZip", PackageZipTask.class, task -> {
                task.setGroup("AzureFunctions");
                task.setDescription("Package current project to staging folder.");
                task.setFunctionsExtension(extension);
            });
            TaskProvider runTask = tasks.register("azureFunctionsRun", LocalRunTask.class, task -> {
                task.setGroup("AzureFunctions");
                task.setDescription("Builds a local folder structure ready to run on azure functions environment.");
                task.setFunctionsExtension(extension);
            });
            TaskProvider deployTask = tasks.register("azureFunctionsDeploy", DeployTask.class, task -> {
                task.setGroup("AzureFunctions");
                task.setDescription("Deploy current project to azure cloud.");
                task.setFunctionsExtension(extension);
            });
            project.afterEvaluate(projectAfterEvaluation -> {
                AzureFunctionsPlugin.mergeCommandLineParameters(extension);
                packageTask.configure(task -> task.dependsOn(new Object[]{"jar"}));
                packageZipTask.configure(task -> task.dependsOn(new Object[]{packageTask}));
                runTask.configure(task -> task.dependsOn(new Object[]{packageTask}));
                deployTask.configure(task -> task.dependsOn(new Object[]{packageTask}));
            });
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Nullable
    private static void mergeCommandLineParameters(AzureFunctionsExtension config) {
        JavaPropsMapper mapper = new JavaPropsMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        Properties properties = System.getProperties();
        try {
            AzureFunctionsExtension commandLineParameters = (AzureFunctionsExtension)mapper.readPropertiesAs(properties, AzureFunctionsExtension.class);
            Utils.copyProperties((Object)config, (Object)commandLineParameters, (boolean)false);
        }
        catch (IOException | IllegalAccessException e) {
            AzureMessager.getMessager().warning(AzureString.format((String)"Failed to read parameters from command line : %s", (Object[])new Object[]{e.getMessage()}));
        }
    }

    static {
        AzureFunctionsPlugin.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AzureFunctionsPlugin.java", AzureFunctionsPlugin.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "apply", "com.microsoft.azure.plugin.functions.gradle.AzureFunctionsPlugin", "org.gradle.api.Project", "project", "", "void"), 44);
    }
}

