/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.plugin.functions.gradle.handler;

import com.azure.core.management.AzureEnvironment;
import com.google.common.base.Preconditions;
import com.microsoft.azure.gradle.configuration.GradleRuntimeConfig;
import com.microsoft.azure.gradle.temeletry.TelemetryAgent;
import com.microsoft.azure.plugin.functions.gradle.GradleFunctionContext;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.appservice.AppServiceAppBase;
import com.microsoft.azure.toolkit.lib.appservice.config.AppServiceConfig;
import com.microsoft.azure.toolkit.lib.appservice.config.FunctionAppConfig;
import com.microsoft.azure.toolkit.lib.appservice.config.RuntimeConfig;
import com.microsoft.azure.toolkit.lib.appservice.entity.FunctionEntity;
import com.microsoft.azure.toolkit.lib.appservice.function.FunctionApp;
import com.microsoft.azure.toolkit.lib.appservice.function.FunctionAppBase;
import com.microsoft.azure.toolkit.lib.appservice.model.FunctionDeployType;
import com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem;
import com.microsoft.azure.toolkit.lib.appservice.model.PricingTier;
import com.microsoft.azure.toolkit.lib.appservice.model.Runtime;
import com.microsoft.azure.toolkit.lib.appservice.model.WebContainer;
import com.microsoft.azure.toolkit.lib.appservice.plan.AppServicePlan;
import com.microsoft.azure.toolkit.lib.appservice.task.CreateOrUpdateFunctionAppTask;
import com.microsoft.azure.toolkit.lib.appservice.utils.AppServiceConfigUtils;
import com.microsoft.azure.toolkit.lib.auth.AzureAccount;
import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.exception.AzureExecutionException;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.model.Region;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.common.utils.Utils;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.gradle.api.JavaVersion;
import org.zeroturnaround.zip.ZipUtil;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;
import reactor.util.retry.Retry;

public class DeployHandler {
    private static final String PORTAL_URL_PATTERN = "%s/#@/resource%s";
    private static final String DEPLOY_START = "Trying to deploy the function app...";
    private static final String DEPLOY_FINISH = "Deployment done, you may access your resource through %s";
    private static final String UNKNOWN_DEPLOYMENT_TYPE = "The value of <deploymentType> is unknown, supported values are: ftp, zip, msdeploy, run_from_blob and run_from_zip.";
    private static final String APPLICATION_INSIGHTS_CONFIGURATION_CONFLICT = "Contradictory configurations for application insights, specify 'appInsightsKey' or 'appInsightsInstance' if you want to enable it, and specify 'disableAppInsights=true' if you want to disable it.";
    private static final String FUNCTION_JAVA_VERSION_KEY = "functionJavaVersion";
    private static final String DISABLE_APP_INSIGHTS_KEY = "disableAppInsights";
    private static final String JVM_UP_TIME = "jvmUpTime";
    private static final String SKIP_DEPLOYMENT_FOR_DOCKER_APP_SERVICE = "Skip deployment for docker app service";
    private static final String LOCAL_SETTINGS_FILE = "local.settings.json";
    private static final String DEPLOY = "deploy";
    private static final String APP_NAME_PATTERN = "[a-zA-Z0-9\\-]{2,60}";
    private static final String RESOURCE_GROUP_PATTERN = "[a-zA-Z0-9._\\-()]{1,90}";
    private static final String APP_SERVICE_PLAN_NAME_PATTERN = "[a-zA-Z0-9\\-]{1,40}";
    private static final String EMPTY_APP_NAME = "Please config the 'appName' in build.gradle.";
    private static final String INVALID_APP_NAME = "The 'appName' only allow alphanumeric characters, hyphens and cannot start or end in a hyphen.";
    private static final String EMPTY_RESOURCE_GROUP = "Please config the 'resourceGroup' in build.gradle.";
    private static final String INVALID_RESOURCE_GROUP_NAME = "The 'resourceGroup' only allow alphanumeric characters, periods, underscores, hyphens and parenthesis and cannot end in a period.";
    private static final String INVALID_SERVICE_PLAN_NAME = "Invalid value for 'appServicePlanName', it need to match the pattern %s";
    private static final String INVALID_SERVICE_PLAN_RESOURCE_GROUP_NAME = "Invalid value for 'appServicePlanResourceGroup', it only allow alphanumeric characters, periods, underscores, hyphens and parenthesis and cannot end in a period.";
    private static final String INVALID_OS = "The value of 'os' is not correct, supported values are: 'windows', 'linux' and 'docker'.";
    private static final String FAILED_TO_LIST_TRIGGERS = "Deployment succeeded, but failed to list http trigger urls.";
    private static final int LIST_TRIGGERS_MAX_RETRY = 5;
    private static final String ARTIFACT_INCOMPATIBLE = "Your function app artifact compile version is higher than the java version in function host, please downgrade the project compile version and try again.";
    private static final String HTTP_TRIGGER_URLS = "HTTP Trigger Urls:";
    private static final String NO_ANONYMOUS_HTTP_TRIGGER = "No anonymous HTTP Triggers found in deployed function app, skip list triggers.";
    private static final String AUTH_LEVEL = "authLevel";
    private static final String HTTP_TRIGGER = "httpTrigger";
    private static final String UNABLE_TO_LIST_NONE_ANONYMOUS_HTTP_TRIGGERS = "Some http trigger urls cannot be displayed because they are non-anonymous. To access the non-anonymous triggers, please refer https://aka.ms/azure-functions-key.";
    private static final String SYNCING_TRIGGERS = "Syncing triggers and fetching function information";
    private static final String SYNCING_TRIGGERS_WITH_RETRY = "Syncing triggers and fetching function information (Attempt {0}/{1})...";
    private static final int LIST_TRIGGERS_RETRY_PERIOD_IN_SECONDS = 10;
    private static final String NO_TRIGGERS_FOUNDED = "No triggers found in deployed function app, please try to deploy the project again.";
    private static final String EXPANDABLE_JAVA_VERSION_WARNING = "'%s' may not be a valid java version, recommended values are `Java 8`, `Java 11` and `Java 17`";
    private static final String EXPANDABLE_PRICING_TIER_WARNING = "'%s' may not be a valid pricing tier, please refer to https://aka.ms/maven_function_configuration#supported-pricing-tiers for valid values";
    private static final String EXPANDABLE_REGION_WARNING = "'%s' may not be a valid region, please refer to https://aka.ms/maven_function_configuration#supported-regions for valid values";
    private final GradleFunctionContext ctx;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public DeployHandler(GradleFunctionContext ctx) {
        Preconditions.checkNotNull((Object)ctx);
        this.ctx = ctx;
    }

    public void execute() throws AzureExecutionException {
        TelemetryAgent.getInstance().addDefaultProperty(FUNCTION_JAVA_VERSION_KEY, String.valueOf(this.javaVersion()));
        TelemetryAgent.getInstance().addDefaultProperty(DISABLE_APP_INSIGHTS_KEY, String.valueOf(this.ctx.isDisableAppInsights()));
        this.doValidate();
        FunctionAppBase<?, ?, ?> app = this.createOrUpdateFunctionApp();
        this.deployArtifact(app);
        if (app instanceof FunctionApp) {
            this.listHTTPTriggerUrls((FunctionApp)app);
        }
    }

    private RuntimeConfig getRuntimeConfig() {
        GradleRuntimeConfig runtime = this.ctx.getRuntime();
        if (runtime == null) {
            return null;
        }
        OperatingSystem os = Optional.ofNullable(runtime.os()).map(OperatingSystem::fromString).orElse(null);
        com.microsoft.azure.toolkit.lib.appservice.model.JavaVersion javaVersion = Optional.ofNullable(runtime.javaVersion()).map(com.microsoft.azure.toolkit.lib.appservice.model.JavaVersion::fromString).orElse(null);
        return new RuntimeConfig().os(os).javaVersion(javaVersion).webContainer(WebContainer.JAVA_OFF).image(runtime.image()).registryUrl(runtime.registryUrl()).username(runtime.username()).password(runtime.password());
    }

    protected void listHTTPTriggerUrls(FunctionApp target) {
        try {
            List<FunctionEntity> triggers = this.listFunctionsWithRetry(target);
            List httpFunction = triggers.stream().filter(function -> function.getTrigger() != null && StringUtils.equalsIgnoreCase((CharSequence)function.getTrigger().getType(), (CharSequence)HTTP_TRIGGER)).collect(Collectors.toList());
            List<FunctionEntity> anonymousTriggers = httpFunction.stream().filter(bindingResource -> bindingResource.getTrigger() != null && StringUtils.equalsIgnoreCase((CharSequence)bindingResource.getTrigger().getProperty(AUTH_LEVEL), (CharSequence)"ANONYMOUS")).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(httpFunction) || CollectionUtils.isEmpty(anonymousTriggers)) {
                AzureMessager.getMessager().info(NO_ANONYMOUS_HTTP_TRIGGER);
                return;
            }
            AzureMessager.getMessager().info(HTTP_TRIGGER_URLS);
            anonymousTriggers.forEach(trigger -> AzureMessager.getMessager().info(String.format("\t %s : %s", trigger.getName(), trigger.getTriggerUrl())));
            if (anonymousTriggers.size() < httpFunction.size()) {
                AzureMessager.getMessager().info(UNABLE_TO_LIST_NONE_ANONYMOUS_HTTP_TRIGGERS);
            }
        }
        catch (RuntimeException e) {
            AzureMessager.getMessager().warning(FAILED_TO_LIST_TRIGGERS);
        }
    }

    private List<FunctionEntity> listFunctionsWithRetry(FunctionApp functionApp) {
        int[] count = new int[]{0};
        return (List)Mono.fromCallable(() -> {
            int n = count[0];
            count[0] = n + 1;
            return this.listFunctions(functionApp, n);
        }).subscribeOn(Schedulers.boundedElastic()).retryWhen((Retry)Retry.fixedDelay((long)4L, (Duration)Duration.ofSeconds(10L))).block();
    }

    @AzureOperation(name="functionapp.list_function.app", params={"functionApp.getName()"}, type=AzureOperation.Type.TASK)
    private List<FunctionEntity> listFunctions(FunctionApp functionApp, int count) {
        FunctionApp functionApp2 = functionApp;
        int n = count;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)functionApp2, (Object)Conversions.intObject((int)n));
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            AzureString message = count == 0 ? AzureString.fromString((String)SYNCING_TRIGGERS) : AzureString.format((String)SYNCING_TRIGGERS_WITH_RETRY, (Object[])new Object[]{count, 5});
            AzureMessager.getDefaultMessager().info(message);
            List list = Optional.of(functionApp.listFunctions(new boolean[]{true})).filter(CollectionUtils::isNotEmpty).orElseThrow(() -> new AzureToolkitRuntimeException(NO_TRIGGERS_FOUNDED));
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return list;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    protected void doValidate() {
        this.validateParameters();
        this.validateApplicationInsightsConfiguration();
    }

    protected void validateParameters() {
        String pricingTier;
        GradleRuntimeConfig runtime;
        String appName = this.ctx.getAppName();
        if (StringUtils.isBlank((CharSequence)appName)) {
            throw new AzureToolkitRuntimeException(EMPTY_APP_NAME);
        }
        if (appName.startsWith("-") || !appName.matches(APP_NAME_PATTERN)) {
            throw new AzureToolkitRuntimeException(INVALID_APP_NAME);
        }
        String resourceGroup = this.ctx.getResourceGroup();
        if (StringUtils.isBlank((CharSequence)resourceGroup)) {
            throw new AzureToolkitRuntimeException(EMPTY_RESOURCE_GROUP);
        }
        if (resourceGroup.endsWith(".") || !resourceGroup.matches(RESOURCE_GROUP_PATTERN)) {
            throw new AzureToolkitRuntimeException(INVALID_RESOURCE_GROUP_NAME);
        }
        String appServicePlanName = this.ctx.getAppServicePlanName();
        if (StringUtils.isNotEmpty((CharSequence)appServicePlanName) && !appServicePlanName.matches(APP_SERVICE_PLAN_NAME_PATTERN)) {
            throw new AzureToolkitRuntimeException(String.format(INVALID_SERVICE_PLAN_NAME, APP_SERVICE_PLAN_NAME_PATTERN));
        }
        String appServicePlanResourceGroup = this.ctx.getAppServicePlanResourceGroup();
        if (StringUtils.isNotEmpty((CharSequence)appServicePlanResourceGroup) && (appServicePlanResourceGroup.endsWith(".") || !appServicePlanResourceGroup.matches(RESOURCE_GROUP_PATTERN))) {
            throw new AzureToolkitRuntimeException(INVALID_SERVICE_PLAN_RESOURCE_GROUP_NAME);
        }
        String region = this.ctx.getRegion();
        if (StringUtils.isNotEmpty((CharSequence)region) && Region.fromName((String)region).isExpandedValue()) {
            AzureMessager.getMessager().warning(AzureString.format((String)EXPANDABLE_REGION_WARNING, (Object[])new Object[]{region}));
        }
        if ((runtime = this.ctx.getRuntime()) != null) {
            if (StringUtils.isNotEmpty((CharSequence)runtime.os()) && OperatingSystem.fromString((String)runtime.os()) == null) {
                throw new AzureToolkitRuntimeException(INVALID_OS);
            }
            if (StringUtils.isNotEmpty((CharSequence)runtime.javaVersion()) && com.microsoft.azure.toolkit.lib.appservice.model.JavaVersion.fromString((String)runtime.javaVersion()).isExpandedValue()) {
                AzureMessager.getMessager().warning(AzureString.format((String)EXPANDABLE_JAVA_VERSION_WARNING, (Object[])new Object[]{runtime.javaVersion()}));
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)(pricingTier = this.ctx.getPricingTier())) && PricingTier.fromString((String)pricingTier) == null) {
            throw new AzureToolkitRuntimeException(String.format(EXPANDABLE_PRICING_TIER_WARNING, pricingTier));
        }
        this.validateApplicationInsightsConfiguration();
    }

    @Nonnull
    private FunctionAppBase<?, ?, ?> createOrUpdateFunctionApp() throws AzureExecutionException {
        FunctionApp app = this.getFunctionApp();
        FunctionAppConfig functionConfig = (FunctionAppConfig)new FunctionAppConfig().disableAppInsights(this.ctx.isDisableAppInsights()).appInsightsKey(this.ctx.getAppInsightsKey()).appInsightsInstance(this.ctx.getAppInsightsInstance()).subscriptionId(this.ctx.getOrCreateAzureAppServiceClient().getSubscriptionId()).resourceGroup(this.ctx.getResourceGroup()).appName(this.ctx.getAppName()).servicePlanName(this.ctx.getAppServicePlanName()).servicePlanResourceGroup(this.ctx.getAppServicePlanResourceGroup()).deploymentSlotName(this.ctx.getDeploymentSlotName()).deploymentSlotConfigurationSource(this.ctx.getDeploymentSlotConfigurationSource()).pricingTier(this.getParsedPricingTier()).region(this.getParsedRegion()).runtime(this.getRuntimeConfig()).appSettings(this.ctx.getAppSettings());
        boolean createFunctionApp = Optional.ofNullable(app).map(function -> !function.exists()).orElse(true);
        AppServiceConfig defaultConfig = createFunctionApp ? this.buildDefaultConfig(functionConfig.subscriptionId(), functionConfig.resourceGroup(), functionConfig.appName()) : AppServiceConfigUtils.fromAppService((AppServiceAppBase)app, (AppServicePlan)Objects.requireNonNull(app.getAppServicePlan()));
        AppServiceConfigUtils.mergeAppServiceConfig((AppServiceConfig)functionConfig, (AppServiceConfig)defaultConfig);
        if (!createFunctionApp && !functionConfig.disableAppInsights() && StringUtils.isBlank((CharSequence)functionConfig.appInsightsKey())) {
            String aiKey = Optional.ofNullable(app.getAppSettings()).map(map -> (String)map.get("APPINSIGHTS_INSTRUMENTATIONKEY")).orElse(null);
            functionConfig.appInsightsKey(aiKey);
        }
        this.validateArtifactCompileVersion(functionConfig.runtime());
        return (FunctionAppBase)new CreateOrUpdateFunctionAppTask(functionConfig).execute();
    }

    private void deployArtifact(@Nonnull FunctionAppBase<?, ?, ?> target) {
        FunctionDeployType deployType;
        boolean isDockerRuntime = Optional.ofNullable(target.getRuntime()).map(Runtime::isDocker).orElse(false);
        if (isDockerRuntime) {
            AzureMessager.getMessager().info(SKIP_DEPLOYMENT_FOR_DOCKER_APP_SERVICE);
            return;
        }
        AzureMessager.getMessager().info(DEPLOY_START);
        String deploymentType = this.ctx.getDeploymentType();
        try {
            deployType = StringUtils.isEmpty((CharSequence)deploymentType) ? null : FunctionDeployType.fromString((String)deploymentType);
        }
        catch (AzureToolkitRuntimeException ex) {
            throw new AzureToolkitRuntimeException(UNKNOWN_DEPLOYMENT_TYPE, (Throwable)ex);
        }
        File file = deployType == FunctionDeployType.FTP ? new File(this.ctx.getDeploymentStagingDirectoryPath()) : this.packageStagingDirectory();
        RunnableWithException deployRunnable = deployType == null ? () -> target.deploy(file) : () -> target.deploy(file, deployType);
        this.executeWithTimeRecorder(deployRunnable, DEPLOY);
        if (!target.getFormalStatus().isRunning()) {
            target.start();
        }
        AzureMessager.getMessager().info(String.format(DEPLOY_FINISH, this.getResourcePortalUrl(target.getId())));
    }

    private void executeWithTimeRecorder(RunnableWithException operation, String name) {
        long startTime = System.currentTimeMillis();
        try {
            operation.run();
        }
        catch (Exception e) {
            try {
                throw new AzureToolkitRuntimeException(e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                long endTime = System.currentTimeMillis();
                TelemetryAgent.getInstance().addDefaultProperty(String.format("%s-cost", name), String.valueOf(endTime - startTime));
                TelemetryAgent.getInstance().addDefaultProperty(JVM_UP_TIME, String.valueOf(ManagementFactory.getRuntimeMXBean().getUptime()));
                throw throwable;
            }
        }
        long endTime = System.currentTimeMillis();
        TelemetryAgent.getInstance().addDefaultProperty(String.format("%s-cost", name), String.valueOf(endTime - startTime));
        TelemetryAgent.getInstance().addDefaultProperty(JVM_UP_TIME, String.valueOf(ManagementFactory.getRuntimeMXBean().getUptime()));
    }

    private File packageStagingDirectory() {
        File zipFile = new File(this.ctx.getDeploymentStagingDirectoryPath() + ".zip");
        File stagingDirectory = new File(this.ctx.getDeploymentStagingDirectoryPath());
        ZipUtil.pack((File)stagingDirectory, (File)zipFile);
        ZipUtil.removeEntry((File)zipFile, (String)LOCAL_SETTINGS_FILE);
        return zipFile;
    }

    public String getResourcePortalUrl(String id) {
        AzureEnvironment environment = ((AzureAccount)Azure.az(AzureAccount.class)).account().getEnvironment();
        return String.format(PORTAL_URL_PATTERN, DeployHandler.getPortalUrl(environment), id);
    }

    private AppServiceConfig buildDefaultConfig(String subscriptionId, String resourceGroup, String appName) {
        com.microsoft.azure.toolkit.lib.appservice.model.JavaVersion javaVersion = JavaVersion.current().isJava8() ? com.microsoft.azure.toolkit.lib.appservice.model.JavaVersion.JAVA_8 : com.microsoft.azure.toolkit.lib.appservice.model.JavaVersion.JAVA_11;
        return AppServiceConfigUtils.buildDefaultFunctionConfig((String)subscriptionId, (String)resourceGroup, (String)appName, (com.microsoft.azure.toolkit.lib.appservice.model.JavaVersion)javaVersion);
    }

    private Region getParsedRegion() {
        return Optional.ofNullable(this.ctx.getRegion()).map(Region::fromName).orElse(null);
    }

    private PricingTier getParsedPricingTier() {
        String pricingTier = this.ctx.getPricingTier();
        if (StringUtils.isEmpty((CharSequence)pricingTier)) {
            return null;
        }
        return Optional.ofNullable(PricingTier.fromString((String)pricingTier)).orElseThrow(() -> new AzureToolkitRuntimeException(String.format("Invalid pricing tier %s", pricingTier)));
    }

    protected void validateArtifactCompileVersion(RuntimeConfig runtime) throws AzureExecutionException {
        File file;
        ComparableVersion artifactVersion;
        if (runtime.os() == OperatingSystem.DOCKER) {
            return;
        }
        ComparableVersion runtimeVersion = new ComparableVersion(runtime.javaVersion().getValue());
        if (runtimeVersion.compareTo(artifactVersion = new ComparableVersion(Utils.getArtifactCompileVersion((File)(file = this.ctx.getProject().getArtifactFile().toFile())))) < 0) {
            throw new AzureToolkitRuntimeException(ARTIFACT_INCOMPATIBLE);
        }
    }

    private com.microsoft.azure.toolkit.lib.appservice.model.JavaVersion javaVersion() {
        return Objects.isNull(this.ctx.getRuntime()) ? null : com.microsoft.azure.toolkit.lib.appservice.model.JavaVersion.fromString((String)this.ctx.getRuntime().javaVersion());
    }

    public FunctionApp getFunctionApp() {
        return (FunctionApp)this.ctx.getOrCreateAzureAppServiceClient().get(this.ctx.getAppName(), this.ctx.getResourceGroup());
    }

    private void validateApplicationInsightsConfiguration() {
        if (this.ctx.isDisableAppInsights() && (StringUtils.isNotEmpty((CharSequence)this.ctx.getAppInsightsKey()) || StringUtils.isNotEmpty((CharSequence)this.ctx.getAppInsightsInstance()))) {
            throw new AzureToolkitRuntimeException(APPLICATION_INSIGHTS_CONFIGURATION_CONFLICT);
        }
    }

    private static String getPortalUrl(AzureEnvironment azureEnvironment) {
        if (azureEnvironment == null || azureEnvironment == AzureEnvironment.AZURE) {
            return "https://ms.portal.azure.com";
        }
        if (azureEnvironment == AzureEnvironment.AZURE_CHINA) {
            return "https://portal.azure.cn";
        }
        return azureEnvironment.getPortal();
    }

    static {
        DeployHandler.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("DeployHandler.java", DeployHandler.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "listFunctions", "com.microsoft.azure.plugin.functions.gradle.handler.DeployHandler", "com.microsoft.azure.toolkit.lib.appservice.function.FunctionApp:int", "functionApp:count", "", "java.util.List"), 178);
    }

    private static interface RunnableWithException {
        public void run() throws Exception;
    }
}

