package com.microsoft.azure.documentdb.internal;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

/**
 * Used internally in the AsyncCache for async operations in the Azure Cosmos DB database service Java SDK.
 */
public final class AsyncLazy<T> {
    private final Callable<T> callable;
    private Future<T> future;
    private final ExecutorService executorService;

    public AsyncLazy(final Callable<T> callable, ExecutorService executorService) {
        this.callable = callable;
        this.executorService = executorService;
    }

    public synchronized Future<T> getValue() {
        if (this.future == null) {
            this.future = this.executorService.submit(this.callable);
        }

        return this.future;
    }

    public boolean isDone() {
        return this.getValue().isDone();
    }

    public boolean isCancelled() {
        return this.getValue().isCancelled();
    }
}
