/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.rx.internal;

import com.microsoft.azure.cosmosdb.BridgeInternal;
import com.microsoft.azure.cosmosdb.ChangeFeedOptions;
import com.microsoft.azure.cosmosdb.FeedResponse;
import com.microsoft.azure.cosmosdb.Resource;
import com.microsoft.azure.cosmosdb.internal.OperationType;
import com.microsoft.azure.cosmosdb.internal.ResourceType;
import com.microsoft.azure.cosmosdb.internal.Utils;
import com.microsoft.azure.cosmosdb.internal.routing.PartitionKeyInternal;
import com.microsoft.azure.cosmosdb.internal.routing.PartitionKeyRangeIdentity;
import com.microsoft.azure.cosmosdb.rx.internal.RxDocumentClientImpl;
import com.microsoft.azure.cosmosdb.rx.internal.RxDocumentServiceRequest;
import com.microsoft.azure.cosmosdb.rx.internal.RxDocumentServiceResponse;
import com.microsoft.azure.cosmosdb.rx.internal.Strings;
import com.microsoft.azure.cosmosdb.rx.internal.query.Paginator;
import java.util.HashMap;
import rx.Observable;
import rx.Single;
import rx.functions.Func1;
import rx.functions.Func2;

class ChangeFeedQueryImpl<T extends Resource> {
    private static final String IfNonMatchAllHeaderValue = "*";
    private final RxDocumentClientImpl client;
    private final ResourceType resourceType;
    private final Class<T> klass;
    private final String documentsLink;
    private final ChangeFeedOptions options;

    public ChangeFeedQueryImpl(RxDocumentClientImpl client, ResourceType resourceType, Class<T> klass, String collectionLink, ChangeFeedOptions changeFeedOptions) {
        this.client = client;
        this.resourceType = resourceType;
        this.klass = klass;
        this.documentsLink = Utils.joinPath((String)collectionLink, (String)"docs");
        ChangeFeedOptions changeFeedOptions2 = changeFeedOptions = changeFeedOptions != null ? changeFeedOptions : new ChangeFeedOptions();
        if (resourceType.isPartitioned() && changeFeedOptions.getPartitionKeyRangeId() == null && changeFeedOptions.getPartitionKey() == null) {
            throw new IllegalArgumentException("One of the partition key range id or partition key must be specified");
        }
        if (changeFeedOptions.getPartitionKey() != null && !Strings.isNullOrEmpty((String)changeFeedOptions.getPartitionKeyRangeId())) {
            throw new IllegalArgumentException(String.format("Both Partition Key and Partition Key range are Specified in %s", "feedOptions"));
        }
        String initialNextIfNoneMatch = null;
        boolean canUseStartFromBeginning = true;
        if (changeFeedOptions.getRequestContinuation() != null) {
            initialNextIfNoneMatch = changeFeedOptions.getRequestContinuation();
            canUseStartFromBeginning = false;
        }
        if (canUseStartFromBeginning && !changeFeedOptions.isStartFromBeginning()) {
            initialNextIfNoneMatch = IfNonMatchAllHeaderValue;
        }
        this.options = this.getChangeFeedOptions(changeFeedOptions, initialNextIfNoneMatch);
    }

    private RxDocumentServiceRequest createDocumentServiceRequest(String continuationToken, int pageSize) {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (this.options.getMaxItemCount() != null) {
            headers.put("x-ms-max-item-count", String.valueOf(this.options.getMaxItemCount()));
        }
        if (continuationToken != null) {
            headers.put("If-None-Match", continuationToken);
        }
        headers.put("A-IM", "Incremental Feed");
        if (this.options.getPartitionKey() != null) {
            PartitionKeyInternal partitionKey = this.options.getPartitionKey().getInternalPartitionKey();
            headers.put("x-ms-documentdb-partitionkey", partitionKey.toJson());
        }
        RxDocumentServiceRequest req = RxDocumentServiceRequest.create((OperationType)OperationType.ReadFeed, (ResourceType)this.resourceType, (String)this.documentsLink, headers);
        if (this.options.getPartitionKeyRangeId() != null) {
            req.routeTo(new PartitionKeyRangeIdentity(this.options.getPartitionKeyRangeId()));
        }
        return req;
    }

    private ChangeFeedOptions getChangeFeedOptions(ChangeFeedOptions options, String continuationToken) {
        ChangeFeedOptions newOps = new ChangeFeedOptions(options);
        newOps.setRequestContinuation(continuationToken);
        return newOps;
    }

    public Observable<FeedResponse<T>> executeAsync() {
        Func2 createRequestFunc = (continuationToken, pageSize) -> this.createDocumentServiceRequest((String)continuationToken, (int)pageSize);
        Func1 executeFunc = request -> this.executeRequestAsync((RxDocumentServiceRequest)request).toObservable();
        return Paginator.getPaginatedChangeFeedQueryResultAsObservable((ChangeFeedOptions)this.options, (Func2)createRequestFunc, (Func1)executeFunc, this.klass, (int)(this.options.getMaxItemCount() != null ? this.options.getMaxItemCount() : -1));
    }

    private Single<FeedResponse<T>> executeRequestAsync(RxDocumentServiceRequest request) {
        return this.client.readFeed(request).toSingle().map(rsp -> BridgeInternal.toChaneFeedResponsePage((RxDocumentServiceResponse)rsp, this.klass));
    }
}

