/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */
package com.microsoft.windowsazure.core.pipeline.apache;

import com.microsoft.windowsazure.core.pipeline.filter.ServiceRequestFilter;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.protocol.HttpContext;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class HttpRequestInterceptorAdapter implements HttpRequestInterceptor {
    private LinkedList<ServiceRequestFilter> filters;

    public HttpRequestInterceptorAdapter() {
        filters = new LinkedList<ServiceRequestFilter>();
    }

    public LinkedList<ServiceRequestFilter> getFilterList()
    {
        return filters;
    }

    @Override
    public void process(HttpRequest request, HttpContext context) {
        HttpServiceRequestContext serviceRequestContext = new HttpServiceRequestContext(request, context);
        for (ServiceRequestFilter filter : filters) {
            filter.filter(serviceRequestContext);
        }
    }
}
