/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.credentials;

import com.google.common.io.BaseEncoding;
import com.microsoft.aad.adal4j.AsymmetricKeyCredential;
import com.microsoft.aad.adal4j.AuthenticationContext;
import com.microsoft.aad.adal4j.AuthenticationException;
import com.microsoft.aad.adal4j.AuthenticationResult;
import com.microsoft.aad.adal4j.ClientCredential;
import com.microsoft.azure.AzureEnvironment;
import com.microsoft.azure.credentials.AuthFile;
import com.microsoft.azure.credentials.AzureTokenCredentials;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ApplicationTokenCredentials
extends AzureTokenCredentials {
    private final ConcurrentHashMap<String, AuthenticationResult> tokens;
    private final ConcurrentHashMap<String, ReentrantLock> authenticationLocks;
    private final String clientId;
    private String clientSecret;
    private byte[] clientCertificate;
    private String clientCertificatePassword;
    private long timeoutInSeconds = 60L;

    public ApplicationTokenCredentials(String clientId, String domain, String secret, AzureEnvironment environment) {
        super(environment, domain);
        this.clientId = clientId;
        this.clientSecret = secret;
        this.tokens = new ConcurrentHashMap();
        this.authenticationLocks = new ConcurrentHashMap();
    }

    public ApplicationTokenCredentials(String clientId, String domain, byte[] certificate, String password, AzureEnvironment environment) {
        super(environment, domain);
        this.clientId = clientId;
        this.clientCertificate = certificate;
        this.clientCertificatePassword = password;
        this.tokens = new ConcurrentHashMap();
        this.authenticationLocks = new ConcurrentHashMap();
    }

    public static ApplicationTokenCredentials fromFile(File credentialsFile) throws IOException {
        return AuthFile.parse(credentialsFile).generateCredentials();
    }

    public String clientId() {
        return this.clientId;
    }

    String clientSecret() {
        return this.clientSecret;
    }

    byte[] clientCertificate() {
        return this.clientCertificate;
    }

    String clientCertificatePassword() {
        return this.clientCertificatePassword;
    }

    public long timeoutInSeconds() {
        return this.timeoutInSeconds;
    }

    public ApplicationTokenCredentials withTimeoutInSeconds(long timeoutInSeconds) {
        this.timeoutInSeconds = timeoutInSeconds;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getToken(String resource) throws IOException {
        AuthenticationResult authenticationResult;
        block13: {
            authenticationResult = this.tokens.get(resource);
            if (authenticationResult == null || authenticationResult.getExpiresOnDate().before(new Date())) {
                ReentrantLock lock;
                ConcurrentHashMap<String, ReentrantLock> concurrentHashMap = this.authenticationLocks;
                synchronized (concurrentHashMap) {
                    lock = this.authenticationLocks.get(resource);
                    if (lock == null) {
                        lock = new ReentrantLock();
                        this.authenticationLocks.put(resource, lock);
                    }
                }
                lock.lock();
                try {
                    authenticationResult = this.tokens.get(resource);
                    if (authenticationResult != null && !authenticationResult.getExpiresOnDate().before(new Date())) break block13;
                    ExecutorService executor = Executors.newSingleThreadExecutor();
                    try {
                        authenticationResult = this.acquireAccessToken(resource, executor).get(this.timeoutInSeconds(), TimeUnit.SECONDS);
                        this.tokens.put(resource, authenticationResult);
                    }
                    finally {
                        executor.shutdown();
                    }
                }
                catch (Exception e) {
                    throw new IOException(e.getMessage(), e);
                }
                finally {
                    lock.unlock();
                }
            }
        }
        return authenticationResult.getAccessToken();
    }

    Future<AuthenticationResult> acquireAccessToken(String resource, ExecutorService executor) throws IOException {
        String authorityUrl = this.environment().activeDirectoryEndpoint() + this.domain();
        AuthenticationContext context = new AuthenticationContext(authorityUrl, false, executor);
        if (this.proxy() != null) {
            context.setProxy(this.proxy());
        }
        if (this.sslSocketFactory() != null) {
            context.setSslSocketFactory(this.sslSocketFactory());
        }
        try {
            if (this.clientSecret != null) {
                return context.acquireToken(resource, new ClientCredential(this.clientId(), this.clientSecret), null);
            }
            if (this.clientCertificate != null && this.clientCertificatePassword != null) {
                return context.acquireToken(resource, AsymmetricKeyCredential.create((String)this.clientId, (InputStream)new ByteArrayInputStream(this.clientCertificate), (String)this.clientCertificatePassword), null);
            }
            if (this.clientCertificate != null) {
                return context.acquireToken(resource, AsymmetricKeyCredential.create((String)this.clientId(), (PrivateKey)ApplicationTokenCredentials.privateKeyFromPem(new String(this.clientCertificate)), (X509Certificate)ApplicationTokenCredentials.publicKeyFromPem(new String(this.clientCertificate))), null);
            }
            throw new AuthenticationException("Please provide either a non-null secret or a non-null certificate.");
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    static PrivateKey privateKeyFromPem(String pem) {
        Pattern pattern = Pattern.compile("(?s)-----BEGIN PRIVATE KEY-----.*-----END PRIVATE KEY-----");
        Matcher matcher = pattern.matcher(pem);
        matcher.find();
        String base64 = matcher.group().replace("-----BEGIN PRIVATE KEY-----", "").replace("-----END PRIVATE KEY-----", "").replace("\n", "").replace("\r", "");
        byte[] key = BaseEncoding.base64().decode((CharSequence)base64);
        PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(key);
        try {
            KeyFactory kf = KeyFactory.getInstance("RSA");
            return kf.generatePrivate(spec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new RuntimeException(e);
        }
    }

    static X509Certificate publicKeyFromPem(String pem) {
        Pattern pattern = Pattern.compile("(?s)-----BEGIN CERTIFICATE-----.*-----END CERTIFICATE-----");
        Matcher matcher = pattern.matcher(pem);
        matcher.find();
        try {
            CertificateFactory factory = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream stream = new ByteArrayInputStream(matcher.group().getBytes());
            return (X509Certificate)factory.generateCertificate(stream);
        }
        catch (CertificateException e) {
            throw new RuntimeException(e);
        }
    }
}

