/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.credentials;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.aad.adal4j.AuthenticationResult;
import com.microsoft.azure.management.apigeneration.Beta;
import com.microsoft.rest.LogLevel;
import com.microsoft.rest.interceptors.LoggingInterceptor;
import com.microsoft.rest.serializer.JacksonAdapter;
import java.net.Proxy;
import java.util.Date;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava.RxJavaCallAdapterFactory;
import retrofit2.http.Field;
import retrofit2.http.FormUrlEncoded;
import retrofit2.http.POST;
import retrofit2.http.Path;
import rx.Observable;

@Beta
final class RefreshTokenClient {
    private final RefreshTokenService service;

    RefreshTokenClient(String baseUrl, Proxy proxy) {
        OkHttpClient.Builder builder = new OkHttpClient.Builder().addInterceptor((Interceptor)new LoggingInterceptor(LogLevel.BODY_AND_HEADERS));
        if (proxy != null) {
            builder = builder.proxy(proxy);
        }
        this.service = (RefreshTokenService)new Retrofit.Builder().addCallAdapterFactory((CallAdapter.Factory)RxJavaCallAdapterFactory.create()).addConverterFactory((Converter.Factory)new JacksonAdapter().converterFactory()).baseUrl(baseUrl).client(builder.build()).build().create(RefreshTokenService.class);
    }

    AuthenticationResult refreshToken(String tenant, String clientId, String resource, String refreshToken, boolean isMultipleResourceRefreshToken) {
        try {
            RefreshTokenResult result = (RefreshTokenResult)this.service.refreshToken(tenant, clientId, "refresh_token", resource, refreshToken).toBlocking().single();
            if (result == null) {
                return null;
            }
            return new AuthenticationResult(result.tokenType, result.accessToken, result.refreshToken, result.expiresIn, null, null, isMultipleResourceRefreshToken);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static class RefreshTokenResult {
        @JsonProperty(value="token_type")
        private String tokenType;
        @JsonProperty(value="expires_in")
        private long expiresIn;
        @JsonProperty(value="expires_on")
        private Date expiresOn;
        @JsonProperty(value="access_token")
        private String accessToken;
        @JsonProperty(value="refresh_token")
        private String refreshToken;

        private RefreshTokenResult() {
        }
    }

    private static interface RefreshTokenService {
        @FormUrlEncoded
        @POST(value="{tenant}/oauth2/token")
        public Observable<RefreshTokenResult> refreshToken(@Path(value="tenant") String var1, @Field(value="client_id") String var2, @Field(value="grant_type") String var3, @Field(value="resource") String var4, @Field(value="refresh_token") String var5);
    }
}

