/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.auth;

import com.microsoft.azure.auth.Constants;
import com.microsoft.azure.auth.exception.AzureLoginFailureException;
import com.microsoft.azure.auth.exception.AzureLoginTimeoutException;
import com.nimbusds.jose.util.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;

public class LocalAuthServer {
    private static String loginSuccessHTMLTemplate;
    private static String loginErrorHTMLTemplate;
    private final Semaphore semaphore = new Semaphore(0);
    private final Server jettyServer;
    private String code;
    private String error;
    private String errorDescription;

    public LocalAuthServer() {
        if (loginErrorHTMLTemplate == null) {
            try {
                LocalAuthServer.initHtmlTemplate();
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot read html pages for local auth server.");
            }
        }
        this.jettyServer = new Server();
        ServerConnector connector = new ServerConnector(this.jettyServer);
        connector.setHost("localhost");
        this.jettyServer.setConnectors(new Connector[]{connector});
        this.jettyServer.setHandler((Handler)new AbstractHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
                LocalAuthServer.initHtmlTemplate();
                try {
                    ((Request)request).setHandled(true);
                    LocalAuthServer.this.code = request.getParameter("code");
                    LocalAuthServer.this.errorDescription = request.getParameter("error_description");
                    LocalAuthServer.this.error = request.getParameter("error");
                    boolean isSuccess = StringUtils.isEmpty((CharSequence)LocalAuthServer.this.error) && StringUtils.isNotEmpty((CharSequence)LocalAuthServer.this.code);
                    response.setStatus(200);
                    response.setContentType("text/html");
                    try (PrintWriter writer = response.getWriter();){
                        writer.write(isSuccess ? loginSuccessHTMLTemplate : String.format(loginErrorHTMLTemplate, LocalAuthServer.this.error, LocalAuthServer.this.errorDescription));
                        writer.flush();
                    }
                    response.flushBuffer();
                }
                finally {
                    LocalAuthServer.this.semaphore.release();
                }
            }
        });
    }

    public URI getURI() {
        return this.jettyServer.getURI();
    }

    public void start() throws IOException {
        if (this.jettyServer.isStarted()) {
            return;
        }
        try {
            this.jettyServer.start();
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new IOException(e);
        }
    }

    public void stop() throws IOException {
        this.semaphore.release();
        try {
            this.jettyServer.stop();
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new IOException(e);
        }
    }

    public String waitForCode() throws InterruptedException, AzureLoginFailureException {
        boolean timeout = false;
        if (!this.semaphore.tryAcquire(5L, TimeUnit.MINUTES)) {
            timeout = true;
            try {
                this.stop();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (StringUtils.isEmpty((CharSequence)this.error) && StringUtils.isNotEmpty((CharSequence)this.code)) {
            return this.code;
        }
        if (StringUtils.isNotEmpty((CharSequence)this.error)) {
            if (StringUtils.isNotEmpty((CharSequence)this.errorDescription)) {
                throw new AzureLoginFailureException(this.error + "\nReason: " + this.errorDescription);
            }
            throw new AzureLoginFailureException(this.error);
        }
        if (timeout) {
            throw new AzureLoginTimeoutException(String.format("Cannot proceed with login after waiting for %d minutes.", 5));
        }
        throw new AzureLoginFailureException("There is no error and no code.");
    }

    static void initHtmlTemplate() throws IOException {
        loginSuccessHTMLTemplate = StringUtils.replace((String)LocalAuthServer.loadResource("success.html"), (String)"${refresh_url}", (String)"https://docs.microsoft.com/en-us/java/api/overview/azure/maven/azure-webapp-maven-plugin/readme/");
        loginErrorHTMLTemplate = StringUtils.replace((String)LocalAuthServer.loadResource("failure.html"), (String)"${refresh_url}", (String)"https://docs.microsoft.com/en-us/java/api/overview/azure/maven/azure-webapp-maven-plugin/readme/");
    }

    static String loadResource(String resourceName) throws IOException {
        return IOUtils.readInputStreamToString((InputStream)LocalAuthServer.class.getClassLoader().getResourceAsStream(resourceName), (Charset)Constants.UTF8);
    }
}

