/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.auth.configuration;

import com.microsoft.azure.auth.AzureAuthHelper;
import com.microsoft.azure.maven.common.ConfigurationProblem;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class AuthConfiguration {
    private String client;
    private String tenant;
    private String key;
    private String certificate;
    private String certificatePassword;
    private String environment;
    private String serverId;
    private String httpProxyHost;
    private String httpProxyPort;

    public String getClient() {
        return this.client;
    }

    public void setClient(String client) {
        this.client = client;
    }

    public String getTenant() {
        return this.tenant;
    }

    public void setTenant(String tenant) {
        this.tenant = tenant;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getCertificate() {
        return this.certificate;
    }

    public void setCertificate(String certificate) {
        this.certificate = certificate;
    }

    public String getCertificatePassword() {
        return this.certificatePassword;
    }

    public void setCertificatePassword(String certificatePassword) {
        this.certificatePassword = certificatePassword;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public String getServerId() {
        return this.serverId;
    }

    public void setServerId(String serverId) {
        this.serverId = serverId;
    }

    public String getHttpProxyHost() {
        return this.httpProxyHost;
    }

    public void setHttpProxyHost(String httpProxyHost) {
        this.httpProxyHost = httpProxyHost;
    }

    public String getHttpProxyPort() {
        return this.httpProxyPort;
    }

    public void setHttpProxyPort(String httpProxyPort) {
        this.httpProxyPort = httpProxyPort;
    }

    public List<ConfigurationProblem> validate() {
        String errorMessagePostfix;
        ArrayList<ConfigurationProblem> results = new ArrayList<ConfigurationProblem>();
        String string = errorMessagePostfix = StringUtils.isNotBlank((CharSequence)this.serverId) ? "server: " + this.serverId + " in settings.xml." : "<auth> configuration.";
        if (StringUtils.isBlank((CharSequence)this.tenant)) {
            results.add(new ConfigurationProblem("tenant", this.tenant, "Cannot find 'tenant' in " + errorMessagePostfix, ConfigurationProblem.Severity.ERROR));
        }
        if (StringUtils.isBlank((CharSequence)this.client)) {
            results.add(new ConfigurationProblem("client", this.client, "Cannot find 'client' in " + errorMessagePostfix, ConfigurationProblem.Severity.ERROR));
        }
        if (StringUtils.isBlank((CharSequence)this.key) && StringUtils.isBlank((CharSequence)this.certificate)) {
            results.add(new ConfigurationProblem("key", null, "Cannot find either 'key' or 'certificate' in " + errorMessagePostfix, ConfigurationProblem.Severity.ERROR));
        }
        if (StringUtils.isNotBlank((CharSequence)this.key) && StringUtils.isNotBlank((CharSequence)this.certificate)) {
            results.add(new ConfigurationProblem(null, null, "It is illegal to specify both 'key' and 'certificate' in " + errorMessagePostfix, ConfigurationProblem.Severity.WARNING));
        }
        if (StringUtils.isNotBlank((CharSequence)this.environment) && !AzureAuthHelper.validateEnvironment(this.environment)) {
            results.add(new ConfigurationProblem("environment", this.environment, String.format("Invalid environment string '%s' in " + errorMessagePostfix, this.environment), ConfigurationProblem.Severity.ERROR));
        }
        if (StringUtils.isNotBlank((CharSequence)this.httpProxyHost) && StringUtils.isBlank((CharSequence)this.httpProxyPort) || StringUtils.isBlank((CharSequence)this.httpProxyHost) && StringUtils.isNotBlank((CharSequence)this.httpProxyPort)) {
            results.add(new ConfigurationProblem(null, null, "'httpProxyHost' and 'httpProxyPort' must both be set if you want to use proxy.", ConfigurationProblem.Severity.ERROR));
        }
        if (StringUtils.isNotBlank((CharSequence)this.httpProxyPort)) {
            if (!StringUtils.isNumeric((CharSequence)this.httpProxyPort)) {
                results.add(new ConfigurationProblem("httpProxyPort", this.httpProxyPort, String.format("Invalid integer number for httpProxyPort: '%s'.", this.httpProxyPort), ConfigurationProblem.Severity.ERROR));
            } else if (NumberUtils.toInt((String)this.httpProxyPort) <= 0 || NumberUtils.toInt((String)this.httpProxyPort) > 65535) {
                results.add(new ConfigurationProblem("httpProxyPort", this.httpProxyPort, String.format("Invalid range of httpProxyPort: '%s', it should be a number between %d and %d", this.httpProxyPort, 1, 65535), ConfigurationProblem.Severity.ERROR));
            }
        }
        return results;
    }
}

