/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.arm.dag;

import com.microsoft.azure.arm.dag.FunctionalTaskItem;
import com.microsoft.azure.arm.dag.TaskGroup;
import com.microsoft.azure.arm.dag.TaskItem;
import com.microsoft.azure.arm.dag.VoidIndexable;
import com.microsoft.azure.arm.model.Appliable;
import com.microsoft.azure.arm.model.Creatable;
import com.microsoft.azure.arm.model.Executable;
import com.microsoft.azure.arm.model.Indexable;
import com.microsoft.azure.arm.utils.SdkContext;
import java.util.Objects;
import rx.Completable;
import rx.Observable;
import rx.functions.Func1;

public abstract class IndexableTaskItem
implements Indexable,
TaskItem,
TaskGroup.HasTaskGroup {
    private final String key;
    private final TaskGroup taskGroup;
    private Indexable taskResult;

    public IndexableTaskItem(String key) {
        this.key = key;
        this.taskGroup = new TaskGroup(this);
        this.taskResult = null;
    }

    public IndexableTaskItem() {
        this(SdkContext.randomUuid());
    }

    public static IndexableTaskItem create(final FunctionalTaskItem taskItem) {
        return new IndexableTaskItem(){

            @Override
            protected Observable<Indexable> invokeTaskAsync(TaskGroup.InvocationContext context) {
                FunctionalTaskItem.Context fContext = new FunctionalTaskItem.Context(this);
                fContext.setInnerContext(context);
                return (Observable)taskItem.call(fContext);
            }
        };
    }

    @Override
    public TaskGroup taskGroup() {
        return this.taskGroup;
    }

    public void clear() {
        this.taskResult = this.voidIndexable();
    }

    @Override
    public String key() {
        return this.key;
    }

    protected String addDependency(FunctionalTaskItem dependency) {
        Objects.requireNonNull(dependency);
        return this.taskGroup.addDependency(dependency);
    }

    protected String addDependency(TaskGroup.HasTaskGroup dependency) {
        Objects.requireNonNull(dependency);
        this.taskGroup.addDependencyTaskGroup(dependency.taskGroup());
        return dependency.taskGroup().key();
    }

    protected String addDependency(Creatable<? extends Indexable> creatable) {
        TaskGroup.HasTaskGroup dependency = (TaskGroup.HasTaskGroup)((Object)creatable);
        return this.addDependency(dependency);
    }

    protected String addeDependency(Appliable<? extends Indexable> appliable) {
        TaskGroup.HasTaskGroup dependency = (TaskGroup.HasTaskGroup)((Object)appliable);
        return this.addDependency(dependency);
    }

    protected String addDependency(Executable<? extends Indexable> executable) {
        TaskGroup.HasTaskGroup dependency = (TaskGroup.HasTaskGroup)((Object)executable);
        return this.addDependency(dependency);
    }

    public String addPostRunDependent(FunctionalTaskItem dependent) {
        Objects.requireNonNull(dependent);
        return this.taskGroup().addPostRunDependent(dependent);
    }

    public String addPostRunDependent(TaskGroup.HasTaskGroup dependent) {
        Objects.requireNonNull(dependent);
        this.taskGroup().addPostRunDependentTaskGroup(dependent.taskGroup());
        return dependent.taskGroup().key();
    }

    protected String addPostRunDependent(Creatable<? extends Indexable> creatable) {
        TaskGroup.HasTaskGroup dependency = (TaskGroup.HasTaskGroup)((Object)creatable);
        return this.addPostRunDependent(dependency);
    }

    protected String addPostRunDependent(Appliable<? extends Indexable> appliable) {
        TaskGroup.HasTaskGroup dependency = (TaskGroup.HasTaskGroup)((Object)appliable);
        return this.addPostRunDependent(dependency);
    }

    protected String addPostRunDependent(Executable<? extends Indexable> executable) {
        TaskGroup.HasTaskGroup dependency = (TaskGroup.HasTaskGroup)((Object)executable);
        return this.addPostRunDependent(dependency);
    }

    protected <T extends Indexable> T taskResult(String key) {
        Indexable result = this.taskGroup.taskResult(key);
        if (result == null) {
            return null;
        }
        Indexable castedResult = result;
        return (T)castedResult;
    }

    @Override
    public Indexable result() {
        return this.taskResult;
    }

    @Override
    public void beforeGroupInvoke() {
    }

    @Override
    public boolean isHot() {
        return false;
    }

    @Override
    public Observable<Indexable> invokeAsync(TaskGroup.InvocationContext context) {
        return this.invokeTaskAsync(context).subscribeOn(SdkContext.getRxScheduler()).map((Func1)new Func1<Indexable, Indexable>(){

            public Indexable call(Indexable result) {
                IndexableTaskItem.this.taskResult = result;
                return result;
            }
        });
    }

    @Override
    public Completable invokeAfterPostRunAsync(boolean isGroupFaulted) {
        return Completable.complete();
    }

    protected abstract Observable<Indexable> invokeTaskAsync(TaskGroup.InvocationContext var1);

    protected Indexable voidIndexable() {
        return new VoidIndexable(this.key);
    }

    protected Observable<Indexable> voidObservable() {
        return Observable.just((Object)this.voidIndexable());
    }
}

