/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.arm.model.implementation;

import com.microsoft.azure.arm.dag.FunctionalTaskItem;
import com.microsoft.azure.arm.dag.TaskGroup;
import com.microsoft.azure.arm.model.Appliable;
import com.microsoft.azure.arm.model.Creatable;
import com.microsoft.azure.arm.model.Executable;
import com.microsoft.azure.arm.model.Indexable;
import com.microsoft.azure.arm.model.implementation.ExecuteTask;
import com.microsoft.azure.arm.model.implementation.IndexableImpl;
import com.microsoft.azure.arm.utils.SdkContext;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import java.util.Objects;
import rx.Completable;
import rx.Observable;
import rx.functions.Func1;

public abstract class ExecutableImpl<FluentModelT extends Indexable>
extends IndexableImpl
implements TaskGroup.HasTaskGroup,
Executable<FluentModelT>,
ExecuteTask.Executor<FluentModelT> {
    private final TaskGroup taskGroup = new TaskGroup(this.key(), new ExecuteTask(this));

    protected ExecutableImpl() {
        this(SdkContext.randomUuid());
    }

    protected ExecutableImpl(String key) {
        super(key);
    }

    @Override
    public TaskGroup taskGroup() {
        return this.taskGroup;
    }

    protected String addDependency(FunctionalTaskItem dependency) {
        Objects.requireNonNull(dependency);
        return this.taskGroup.addDependency(dependency);
    }

    protected String addDependency(TaskGroup.HasTaskGroup dependency) {
        Objects.requireNonNull(dependency);
        this.taskGroup.addDependencyTaskGroup(dependency.taskGroup());
        return dependency.taskGroup().key();
    }

    protected String addDependency(Creatable<? extends Indexable> creatable) {
        TaskGroup.HasTaskGroup dependency = (TaskGroup.HasTaskGroup)((Object)creatable);
        return this.addDependency(dependency);
    }

    protected String addeDependency(Appliable<? extends Indexable> appliable) {
        TaskGroup.HasTaskGroup dependency = (TaskGroup.HasTaskGroup)((Object)appliable);
        return this.addDependency(dependency);
    }

    protected String addDependency(Executable<? extends Indexable> executable) {
        TaskGroup.HasTaskGroup dependency = (TaskGroup.HasTaskGroup)((Object)executable);
        return this.addDependency(dependency);
    }

    public String addPostRunDependent(FunctionalTaskItem dependent) {
        Objects.requireNonNull(dependent);
        return this.taskGroup().addPostRunDependent(dependent);
    }

    protected String addPostRunDependent(TaskGroup.HasTaskGroup dependent) {
        Objects.requireNonNull(dependent);
        this.taskGroup.addPostRunDependentTaskGroup(dependent.taskGroup());
        return dependent.taskGroup().key();
    }

    protected String addPostRunDependent(Creatable<? extends Indexable> creatable) {
        TaskGroup.HasTaskGroup dependency = (TaskGroup.HasTaskGroup)((Object)creatable);
        return this.addPostRunDependent(dependency);
    }

    protected String addPostRunDependent(Appliable<? extends Indexable> appliable) {
        TaskGroup.HasTaskGroup dependency = (TaskGroup.HasTaskGroup)((Object)appliable);
        return this.addPostRunDependent(dependency);
    }

    protected String addPostRunDependent(Executable<? extends Indexable> executable) {
        TaskGroup.HasTaskGroup dependency = (TaskGroup.HasTaskGroup)((Object)executable);
        return this.addPostRunDependent(dependency);
    }

    protected <T extends Indexable> T taskResult(String key) {
        Indexable result = this.taskGroup.taskResult(key);
        if (result == null) {
            return null;
        }
        Indexable castedResult = result;
        return (T)castedResult;
    }

    @Override
    public void beforeGroupExecute() {
    }

    @Override
    public boolean isHot() {
        return false;
    }

    @Override
    public Observable<FluentModelT> executeAsync() {
        return this.taskGroup.invokeAsync(this.taskGroup.newInvocationContext()).last().map(new Func1<Indexable, FluentModelT>(){

            public FluentModelT call(Indexable indexable) {
                return indexable;
            }
        });
    }

    @Override
    public FluentModelT execute() {
        return (FluentModelT)((Indexable)this.executeAsync().toBlocking().last());
    }

    @Override
    public ServiceFuture<FluentModelT> executeAsync(ServiceCallback<FluentModelT> callback) {
        return ServiceFuture.fromBody(this.executeAsync(), callback);
    }

    @Override
    public Completable afterPostRunAsync(boolean isGroupFaulted) {
        return Completable.complete();
    }
}

