/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.web.dependencies.http.protocol;

import com.microsoft.applicationinsights.web.dependencies.http.HttpException;
import com.microsoft.applicationinsights.web.dependencies.http.HttpResponse;
import com.microsoft.applicationinsights.web.dependencies.http.HttpResponseInterceptor;
import com.microsoft.applicationinsights.web.dependencies.http.annotation.Contract;
import com.microsoft.applicationinsights.web.dependencies.http.annotation.ThreadingBehavior;
import com.microsoft.applicationinsights.web.dependencies.http.protocol.HttpContext;
import com.microsoft.applicationinsights.web.dependencies.http.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class ResponseServer
implements HttpResponseInterceptor {
    private final String originServer;

    public ResponseServer(String originServer) {
        this.originServer = originServer;
    }

    public ResponseServer() {
        this(null);
    }

    @Override
    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        Args.notNull(response, "HTTP response");
        if (!response.containsHeader("Server") && this.originServer != null) {
            response.addHeader("Server", this.originServer);
        }
    }
}

