/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.processor;

import com.microsoft.applicationinsights.core.dependencies.apachecommons.lang3.exception.ExceptionUtils;
import com.microsoft.applicationinsights.extensibility.TelemetryProcessor;
import com.microsoft.applicationinsights.internal.annotation.BuiltInProcessor;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.internal.util.LocalStringsUtils;
import com.microsoft.applicationinsights.telemetry.PageViewTelemetry;
import com.microsoft.applicationinsights.telemetry.Telemetry;
import java.net.URI;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@BuiltInProcessor(value="PageViewTelemetryFilter")
public final class PageViewTelemetryFilter
implements TelemetryProcessor {
    private long durationThresholdInMS = 0L;
    private final Set<String> notNeededUrls = new HashSet<String>();
    private final Set<String> notNeededNames = new HashSet<String>();

    @Override
    public boolean process(Telemetry telemetry) {
        if (telemetry == null) {
            return true;
        }
        if (!(telemetry instanceof PageViewTelemetry)) {
            return true;
        }
        PageViewTelemetry asPVT = (PageViewTelemetry)telemetry;
        URI uri = asPVT.getUri();
        if (uri == null) {
            return true;
        }
        String uriPath = uri.toString();
        for (String notNeededUri : this.notNeededUrls) {
            if (!uriPath.contains(notNeededUri)) continue;
            return false;
        }
        if (this.notNeededNames.contains(asPVT.getName())) {
            return false;
        }
        long pvtDuration = asPVT.getDuration();
        return this.durationThresholdInMS <= pvtDuration;
    }

    public void setDurationThresholdInMS(String durationThresholdInMS) throws NumberFormatException {
        try {
            this.durationThresholdInMS = Long.parseLong(durationThresholdInMS);
            InternalLogger.INSTANCE.trace("PageViewTelemetryFilter: successfully set DurationThresholdInMS to %s", durationThresholdInMS);
        }
        catch (NumberFormatException e) {
            InternalLogger.INSTANCE.error("PageViewTelemetryFilter: failed to set DurationThresholdInMS:%s Exception : %s ", durationThresholdInMS, ExceptionUtils.getStackTrace(e));
            throw e;
        }
    }

    public void setNotNeededNames(String notNeededNames) throws Throwable {
        try {
            List<String> notNeededAsList = Arrays.asList(notNeededNames.split(","));
            for (String notNeeded : notNeededAsList) {
                String ready = notNeeded.trim();
                if (LocalStringsUtils.isNullOrEmpty(ready)) continue;
                this.notNeededNames.add(ready);
            }
            InternalLogger.INSTANCE.trace(String.format("PageViewTelemetryFilter: set NotNeededNames: %s", notNeededNames), new Object[0]);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                InternalLogger.INSTANCE.trace("PageViewTelemetryFilter: failed to parse NotNeededNames: %s Exception : %s", notNeededNames, ExceptionUtils.getStackTrace(t));
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw t;
        }
    }

    public void setNotNeededUrls(String notNeededUrls) throws Throwable {
        try {
            List<String> notNeededAsList = Arrays.asList(notNeededUrls.split(","));
            for (String notNeeded : notNeededAsList) {
                String ready = notNeeded.trim();
                if (LocalStringsUtils.isNullOrEmpty(ready)) continue;
                this.notNeededUrls.add(ready);
            }
            InternalLogger.INSTANCE.trace("PageViewTelemetryFilter: set %s", notNeededUrls);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                InternalLogger.INSTANCE.error("PageViewTelemetryFilter: failed to parse NotNeededUrls: %s Exception : %s", notNeededUrls, ExceptionUtils.getStackTrace(t));
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw t;
        }
    }
}

