/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.config;

import com.microsoft.applicationinsights.TelemetryConfiguration;
import com.microsoft.applicationinsights.channel.TelemetryChannel;
import com.microsoft.applicationinsights.channel.TelemetrySampler;
import com.microsoft.applicationinsights.channel.concrete.inprocess.InProcessTelemetryChannel;
import com.microsoft.applicationinsights.core.dependencies.apachecommons.lang3.exception.ExceptionUtils;
import com.microsoft.applicationinsights.core.dependencies.google.common.annotations.VisibleForTesting;
import com.microsoft.applicationinsights.core.dependencies.google.common.base.Strings;
import com.microsoft.applicationinsights.extensibility.PerformanceCountersCollectionPlugin;
import com.microsoft.applicationinsights.extensibility.TelemetryInitializer;
import com.microsoft.applicationinsights.extensibility.TelemetryModule;
import com.microsoft.applicationinsights.extensibility.TelemetryProcessor;
import com.microsoft.applicationinsights.internal.annotation.AnnotationPackageScanner;
import com.microsoft.applicationinsights.internal.annotation.BuiltInProcessor;
import com.microsoft.applicationinsights.internal.annotation.PerformanceModule;
import com.microsoft.applicationinsights.internal.channel.samplingV2.FixedRateSamplingTelemetryProcessor;
import com.microsoft.applicationinsights.internal.config.AppInsightsConfigurationBuilder;
import com.microsoft.applicationinsights.internal.config.ApplicationInsightsXmlConfiguration;
import com.microsoft.applicationinsights.internal.config.ChannelXmlElement;
import com.microsoft.applicationinsights.internal.config.ConfigurationFileLocator;
import com.microsoft.applicationinsights.internal.config.ContextInitializersInitializer;
import com.microsoft.applicationinsights.internal.config.ContextInitializersXmlElement;
import com.microsoft.applicationinsights.internal.config.JaxbAppInsightsConfigurationBuilder;
import com.microsoft.applicationinsights.internal.config.JmxXmlElement;
import com.microsoft.applicationinsights.internal.config.PerformanceCountersXmlElement;
import com.microsoft.applicationinsights.internal.config.QuickPulseXmlElement;
import com.microsoft.applicationinsights.internal.config.ReflectionUtils;
import com.microsoft.applicationinsights.internal.config.SDKLoggerXmlElement;
import com.microsoft.applicationinsights.internal.config.SamplerXmlElement;
import com.microsoft.applicationinsights.internal.config.TelemetryInitializersXmlElement;
import com.microsoft.applicationinsights.internal.config.TelemetryModulesXmlElement;
import com.microsoft.applicationinsights.internal.config.TelemetryProcessorCreator;
import com.microsoft.applicationinsights.internal.config.TelemetryProcessorXmlElement;
import com.microsoft.applicationinsights.internal.config.TelemetryProcessorsXmlElement;
import com.microsoft.applicationinsights.internal.config.TelemetrySamplerInitializer;
import com.microsoft.applicationinsights.internal.heartbeat.HeartBeatModule;
import com.microsoft.applicationinsights.internal.jmx.JmxAttributeData;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.internal.perfcounter.JmxMetricPerformanceCounter;
import com.microsoft.applicationinsights.internal.perfcounter.JvmPerformanceCountersModule;
import com.microsoft.applicationinsights.internal.perfcounter.PerformanceCounterConfigurationAware;
import com.microsoft.applicationinsights.internal.perfcounter.PerformanceCounterContainer;
import com.microsoft.applicationinsights.internal.perfcounter.ProcessPerformanceCountersModule;
import com.microsoft.applicationinsights.internal.processor.PageViewTelemetryFilter;
import com.microsoft.applicationinsights.internal.processor.RequestTelemetryFilter;
import com.microsoft.applicationinsights.internal.processor.SyntheticSourceFilter;
import com.microsoft.applicationinsights.internal.processor.TelemetryEventFilter;
import com.microsoft.applicationinsights.internal.processor.TraceTelemetryFilter;
import com.microsoft.applicationinsights.internal.quickpulse.QuickPulse;
import com.microsoft.applicationinsights.internal.util.LocalStringsUtils;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public enum TelemetryConfigurationFactory {
    INSTANCE;

    private static final String CONFIG_FILE_NAME = "ApplicationInsights.xml";
    private static final String DEFAULT_PERFORMANCE_MODULES_PACKAGE = "com.microsoft.applicationinsights";
    private static final String BUILT_IN_NAME = "BuiltIn";
    public static final String BUILTIN_PROCESSORS_SCANNING_ENABLED_PROPERTY = "applicationinsights.processors.builtin.scanning.enabled";
    public static final String PERFORMANCE_MODULES_SCANNING_ENABLED_PROPERTY = "applicationinsights.modules.performance.scanning.enabled";
    public static final String CONNECTION_STRING_ENV_VAR_NAME = "APPLICATIONINSIGHTS_CONNECTION_STRING";
    private String performanceCountersSection = "com.microsoft.applicationinsights";
    static final String EXTERNAL_PROPERTY_IKEY_NAME = "APPLICATION_INSIGHTS_IKEY";
    static final String EXTERNAL_PROPERTY_IKEY_NAME_SECONDARY = "APPINSIGHTS_INSTRUMENTATIONKEY";
    @VisibleForTesting
    AppInsightsConfigurationBuilder builder = new JaxbAppInsightsConfigurationBuilder();
    private static final Set<String> defaultPerformaceModuleClassNames;

    public static synchronized void addDefaultPerfModuleClassName(String name) {
        defaultPerformaceModuleClassNames.add(name);
    }

    public final void initialize(TelemetryConfiguration configuration) {
        try (InputStream configurationFile = new ConfigurationFileLocator(CONFIG_FILE_NAME).getConfigurationFile();){
            if (configurationFile == null) {
                this.setMinimumConfiguration(null, configuration);
                return;
            }
            ApplicationInsightsXmlConfiguration applicationInsightsConfig = this.builder.build(configurationFile);
            if (applicationInsightsConfig == null) {
                InternalLogger.INSTANCE.error("Failed to read configuration file. Application Insights XML file is null...setting default configuration", new Object[0]);
                this.setMinimumConfiguration(null, configuration);
                return;
            }
            this.setInternalLogger(applicationInsightsConfig.getSdkLogger(), configuration);
            this.setInstrumentationKey(applicationInsightsConfig, configuration);
            this.setConnectionString(applicationInsightsConfig, configuration);
            this.setRoleName(applicationInsightsConfig, configuration);
            TelemetrySampler telemetrySampler = this.getSampler(applicationInsightsConfig.getSampler());
            boolean channelIsConfigured = this.setChannel(applicationInsightsConfig.getChannel(), telemetrySampler, configuration);
            if (!channelIsConfigured) {
                InternalLogger.INSTANCE.warn("No channel was initialized. A channel must be set before telemetry tracking will operate correctly.", new Object[0]);
            }
            configuration.setTrackingIsDisabled(applicationInsightsConfig.isDisableTelemetry());
            this.setContextInitializers(applicationInsightsConfig.getContextInitializers(), configuration);
            this.setTelemetryInitializers(applicationInsightsConfig.getTelemetryInitializers(), configuration);
            this.setTelemetryModules(applicationInsightsConfig, configuration);
            this.setTelemetryProcessors(applicationInsightsConfig, configuration);
            this.setQuickPulse(applicationInsightsConfig, configuration);
            this.initializeComponents(configuration);
        }
        catch (Exception e) {
            InternalLogger.INSTANCE.error("Failed to initialize configuration, exception: %s", ExceptionUtils.getStackTrace(e));
        }
    }

    private void setMinimumConfiguration(ApplicationInsightsXmlConfiguration userConfiguration, TelemetryConfiguration configuration) {
        this.setInstrumentationKey(userConfiguration, configuration);
        this.setRoleName(userConfiguration, configuration);
        configuration.setChannel(new InProcessTelemetryChannel(configuration));
        this.addHeartBeatModule(configuration);
        this.setContextInitializers(null, configuration);
        this.initializeComponents(configuration);
    }

    private void setInternalLogger(SDKLoggerXmlElement sdkLogger, TelemetryConfiguration configuration) {
        if (sdkLogger == null) {
            return;
        }
        InternalLogger.INSTANCE.initialize(sdkLogger.getType(), sdkLogger.getData());
    }

    private void setTelemetryInitializers(TelemetryInitializersXmlElement telemetryInitializers, TelemetryConfiguration configuration) {
        if (telemetryInitializers == null) {
            return;
        }
        List<TelemetryInitializer> initializerList = configuration.getTelemetryInitializers();
        ReflectionUtils.loadComponents(TelemetryInitializer.class, initializerList, telemetryInitializers.getAdds());
    }

    private void setContextInitializers(ContextInitializersXmlElement contextInitializers, TelemetryConfiguration configuration) {
        new ContextInitializersInitializer().initialize(contextInitializers, configuration);
    }

    private void setQuickPulse(ApplicationInsightsXmlConfiguration appConfiguration, TelemetryConfiguration configuration) {
        if (this.isQuickPulseEnabledInConfiguration(appConfiguration)) {
            InternalLogger.INSTANCE.trace("Initializing QuickPulse...", new Object[0]);
            QuickPulse.INSTANCE.initialize(configuration);
        }
    }

    private boolean isQuickPulseEnabledInConfiguration(ApplicationInsightsXmlConfiguration appConfiguration) {
        QuickPulseXmlElement quickPulseXmlElement = appConfiguration.getQuickPulse();
        return quickPulseXmlElement.isEnabled();
    }

    private void setTelemetryModules(ApplicationInsightsXmlConfiguration appConfiguration, TelemetryConfiguration configuration) {
        TelemetryModulesXmlElement configurationModules = appConfiguration.getModules();
        List<TelemetryModule> modules = configuration.getTelemetryModules();
        if (configurationModules != null) {
            ReflectionUtils.loadComponents(TelemetryModule.class, modules, configurationModules.getAdds());
        }
        if (!this.isHeartBeatModuleAdded(modules)) {
            this.addHeartBeatModule(configuration);
        }
        List<TelemetryModule> pcModules = this.getPerformanceModules(appConfiguration.getPerformance());
        modules.addAll(pcModules);
    }

    private void setTelemetryProcessors(ApplicationInsightsXmlConfiguration appConfiguration, TelemetryConfiguration configuration) {
        TelemetryProcessorsXmlElement configurationProcessors = appConfiguration.getTelemetryProcessors();
        List<TelemetryProcessor> processors = configuration.getTelemetryProcessors();
        if (configurationProcessors != null) {
            ArrayList<TelemetryProcessorXmlElement> b = configurationProcessors.getBuiltInTelemetryProcessors();
            if (!b.isEmpty()) {
                List<String> processorsBuiltInNames = new ArrayList<String>();
                if (System.getProperty(BUILTIN_PROCESSORS_SCANNING_ENABLED_PROPERTY, "false").equalsIgnoreCase("true")) {
                    processorsBuiltInNames = AnnotationPackageScanner.scanForClassAnnotations(new Class[]{BuiltInProcessor.class}, this.performanceCountersSection);
                } else {
                    this.addDefaultBuiltInProcessors(processorsBuiltInNames);
                }
                HashMap<String, String> builtInMap = new HashMap<String, String>();
                for (String processorsBuiltInName : processorsBuiltInNames) {
                    builtInMap.put(processorsBuiltInName.substring(processorsBuiltInName.lastIndexOf(".") + 1), processorsBuiltInName);
                }
                ArrayList<TelemetryProcessorXmlElement> validProcessors = new ArrayList<TelemetryProcessorXmlElement>();
                for (TelemetryProcessorXmlElement element : b) {
                    String fullTypeName = (String)builtInMap.get(element.getType());
                    if (LocalStringsUtils.isNullOrEmpty(fullTypeName)) {
                        InternalLogger.INSTANCE.error("Failed to find built in processor: '%s', ignored", element.getType());
                        continue;
                    }
                    element.setType(fullTypeName);
                    validProcessors.add(element);
                }
                this.loadProcessorComponents(processors, validProcessors);
            }
            ArrayList<TelemetryProcessorXmlElement> customs = configurationProcessors.getCustomTelemetryProcessors();
            this.loadProcessorComponents(processors, customs);
        }
    }

    private void addDefaultBuiltInProcessors(List<String> p) {
        p.add(FixedRateSamplingTelemetryProcessor.class.getCanonicalName());
        p.add(PageViewTelemetryFilter.class.getCanonicalName());
        p.add(RequestTelemetryFilter.class.getCanonicalName());
        p.add(SyntheticSourceFilter.class.getCanonicalName());
        p.add(TelemetryEventFilter.class.getCanonicalName());
        p.add(TraceTelemetryFilter.class.getCanonicalName());
    }

    private void setInstrumentationKey(ApplicationInsightsXmlConfiguration userConfiguration, TelemetryConfiguration configuration) {
        try {
            String ikey = System.getProperty(EXTERNAL_PROPERTY_IKEY_NAME);
            if (!Strings.isNullOrEmpty(ikey)) {
                configuration.setInstrumentationKey(ikey);
                return;
            }
            ikey = System.getProperty(EXTERNAL_PROPERTY_IKEY_NAME_SECONDARY);
            if (!Strings.isNullOrEmpty(ikey)) {
                configuration.setInstrumentationKey(ikey);
                return;
            }
            ikey = System.getenv(EXTERNAL_PROPERTY_IKEY_NAME);
            if (!Strings.isNullOrEmpty(ikey)) {
                configuration.setInstrumentationKey(ikey);
                return;
            }
            ikey = System.getenv(EXTERNAL_PROPERTY_IKEY_NAME_SECONDARY);
            if (!Strings.isNullOrEmpty(ikey)) {
                configuration.setInstrumentationKey(ikey);
                return;
            }
            if (userConfiguration != null) {
                ikey = userConfiguration.getInstrumentationKey();
                if (ikey == null) {
                    return;
                }
                if ((ikey = ikey.trim()).length() == 0) {
                    return;
                }
                configuration.setInstrumentationKey(ikey);
            }
        }
        catch (Exception e) {
            InternalLogger.INSTANCE.error("Failed to set instrumentation key: '%s'", e.toString());
        }
    }

    private void setConnectionString(ApplicationInsightsXmlConfiguration configXml, TelemetryConfiguration configuration) {
        String connectionString = configXml.getConnectionString();
        String nextValue = System.getenv(CONNECTION_STRING_ENV_VAR_NAME);
        if (!Strings.isNullOrEmpty(nextValue)) {
            if (!Strings.isNullOrEmpty(connectionString)) {
                InternalLogger.INSTANCE.warn("Environment variable %s is overriding connection string value from %s", CONNECTION_STRING_ENV_VAR_NAME, CONFIG_FILE_NAME);
            }
            connectionString = nextValue;
        }
        if (connectionString != null) {
            configuration.setConnectionString(connectionString);
        }
    }

    private void setRoleName(ApplicationInsightsXmlConfiguration userConfiguration, TelemetryConfiguration configuration) {
        try {
            if (userConfiguration != null) {
                String roleName = userConfiguration.getRoleName();
                if (roleName == null) {
                    return;
                }
                if ((roleName = roleName.trim()).length() == 0) {
                    return;
                }
                configuration.setRoleName(roleName);
            }
        }
        catch (Exception e) {
            InternalLogger.INSTANCE.error("Failed to set role name: '%s'", e.toString());
        }
    }

    private List<TelemetryModule> getPerformanceModules(PerformanceCountersXmlElement performanceConfigurationData) {
        PerformanceCounterContainer.INSTANCE.setCollectionFrequencyInSec(performanceConfigurationData.getCollectionFrequencyInSec());
        String pluginName = performanceConfigurationData.getPlugin();
        if (!LocalStringsUtils.isNullOrEmpty(pluginName)) {
            PerformanceCountersCollectionPlugin plugin = ReflectionUtils.createInstance(pluginName, PerformanceCountersCollectionPlugin.class);
            PerformanceCounterContainer.INSTANCE.setPlugin(plugin);
        }
        ArrayList<TelemetryModule> modules = new ArrayList<TelemetryModule>();
        List<String> performanceModuleNames = new ArrayList<String>();
        if (System.getProperty(PERFORMANCE_MODULES_SCANNING_ENABLED_PROPERTY, "false").equalsIgnoreCase("true")) {
            performanceModuleNames = AnnotationPackageScanner.scanForClassAnnotations(new Class[]{PerformanceModule.class}, this.performanceCountersSection);
        }
        if (performanceModuleNames.size() == 0) {
            InternalLogger.INSTANCE.trace("Default performance counters will be automatically loaded.", new Object[0]);
            performanceModuleNames.addAll(this.getDefaultPerformanceModulesNames());
        }
        for (String performanceModuleName : performanceModuleNames) {
            TelemetryModule module = ReflectionUtils.createInstance(performanceModuleName, TelemetryModule.class);
            if (module != null) {
                PerformanceModule pmAnnotation = module.getClass().getAnnotation(PerformanceModule.class);
                if (!performanceConfigurationData.isUseBuiltIn() && BUILT_IN_NAME.equals(pmAnnotation.value())) continue;
                if (module instanceof PerformanceCounterConfigurationAware) {
                    PerformanceCounterConfigurationAware awareModule = (PerformanceCounterConfigurationAware)((Object)module);
                    try {
                        awareModule.addConfigurationData(performanceConfigurationData);
                    }
                    catch (Exception e) {
                        InternalLogger.INSTANCE.error("Failed to add configuration data to performance module: '%s'", e.toString());
                    }
                }
                modules.add(module);
                continue;
            }
            InternalLogger.INSTANCE.error("Failed to create performance module: '%s'", performanceModuleName);
        }
        this.loadCustomJmxPCs(performanceConfigurationData.getJmxXmlElements());
        return modules;
    }

    private Set<String> getDefaultPerformanceModulesNames() {
        return defaultPerformaceModuleClassNames;
    }

    private void loadCustomJmxPCs(ArrayList<JmxXmlElement> jmxXmlElements) {
        try {
            if (jmxXmlElements == null) {
                return;
            }
            HashMap data = new HashMap();
            for (JmxXmlElement jmxXmlElement : jmxXmlElements) {
                ArrayList<JmxAttributeData> collection = (ArrayList<JmxAttributeData>)data.get(jmxXmlElement.getObjectName());
                if (collection == null) {
                    collection = new ArrayList<JmxAttributeData>();
                    data.put(jmxXmlElement.getObjectName(), collection);
                }
                if (Strings.isNullOrEmpty(jmxXmlElement.getObjectName())) {
                    InternalLogger.INSTANCE.error("JMX object name is empty, will be ignored", new Object[0]);
                    continue;
                }
                if (Strings.isNullOrEmpty(jmxXmlElement.getAttribute())) {
                    InternalLogger.INSTANCE.error("JMX attribute is empty for '%s', will be ignored", jmxXmlElement.getObjectName());
                    continue;
                }
                if (Strings.isNullOrEmpty(jmxXmlElement.getDisplayName())) {
                    InternalLogger.INSTANCE.error("JMX display name is empty for '%s', will be ignored", jmxXmlElement.getObjectName());
                    continue;
                }
                collection.add(new JmxAttributeData(jmxXmlElement.getDisplayName(), jmxXmlElement.getAttribute(), jmxXmlElement.getType()));
            }
            for (Map.Entry entry : data.entrySet()) {
                try {
                    if (PerformanceCounterContainer.INSTANCE.register(new JmxMetricPerformanceCounter((String)entry.getKey(), (String)entry.getKey(), (Collection)entry.getValue()))) {
                        InternalLogger.INSTANCE.trace("Registered JMX performance counter '%s'", entry.getKey());
                        continue;
                    }
                    InternalLogger.INSTANCE.trace("Failed to register JMX performance counter '%s'", entry.getKey());
                }
                catch (Exception e) {
                    InternalLogger.INSTANCE.error("Failed to register JMX performance counter '%s': '%s'", entry.getKey(), e.toString());
                }
            }
        }
        catch (Exception e) {
            InternalLogger.INSTANCE.error("Failed to register JMX performance counters: '%s'", e.toString());
        }
    }

    private TelemetrySampler getSampler(SamplerXmlElement sampler) {
        return new TelemetrySamplerInitializer().getSampler(sampler);
    }

    private boolean setChannel(ChannelXmlElement channelXmlElement, TelemetrySampler telemetrySampler, TelemetryConfiguration configuration) {
        TelemetryChannel channel;
        String channelName = channelXmlElement.getType();
        if (channelName != null) {
            channel = this.createChannel(channelXmlElement, configuration);
            if (channel != null) {
                channel.setSampler(telemetrySampler);
                configuration.setChannel(channel);
                return true;
            }
            InternalLogger.INSTANCE.error("Failed to create '%s'", channelName);
            if (!InProcessTelemetryChannel.class.getCanonicalName().equals(channelName)) {
                return false;
            }
        }
        try {
            channel = new InProcessTelemetryChannel(configuration, channelXmlElement.getData());
            channel.setSampler(telemetrySampler);
            configuration.setChannel(channel);
            return true;
        }
        catch (Exception e) {
            InternalLogger.INSTANCE.error("Failed to create InProcessTelemetryChannel, exception: %s, will create the default one with default arguments", e.toString());
            InProcessTelemetryChannel channel2 = new InProcessTelemetryChannel(configuration);
            channel2.setSampler(telemetrySampler);
            configuration.setChannel(channel2);
            return true;
        }
    }

    private TelemetryChannel createChannel(ChannelXmlElement channelXmlElement, TelemetryConfiguration configuration) {
        String channelName = channelXmlElement.getType();
        TelemetryChannel channel = ReflectionUtils.createConfiguredInstance(channelName, TelemetryChannel.class, configuration, channelXmlElement.getData());
        if (channel == null) {
            channel = ReflectionUtils.createInstance(channelName, TelemetryChannel.class, Map.class, channelXmlElement.getData());
        }
        return channel;
    }

    private void loadProcessorComponents(List<TelemetryProcessor> list, Collection<TelemetryProcessorXmlElement> classesFromConfiguration) {
        if (classesFromConfiguration == null) {
            return;
        }
        TelemetryProcessorCreator creator = new TelemetryProcessorCreator();
        for (TelemetryProcessorXmlElement classData : classesFromConfiguration) {
            TelemetryProcessor processor = creator.Create(classData);
            if (processor == null) {
                InternalLogger.INSTANCE.error("Processor %s failure during initialization", classData.getType());
                continue;
            }
            InternalLogger.INSTANCE.trace("Processor %s was added successfully", classData.getType());
            list.add(processor);
        }
    }

    private void initializeComponents(TelemetryConfiguration configuration) {
        List<TelemetryModule> telemetryModules = configuration.getTelemetryModules();
        for (TelemetryModule module : telemetryModules) {
            try {
                module.initialize(configuration);
            }
            catch (Exception e) {
                InternalLogger.INSTANCE.error("Failed to initialized telemetry module " + module.getClass().getSimpleName() + ". Exception", new Object[0]);
            }
        }
    }

    private void addHeartBeatModule(TelemetryConfiguration configuration) {
        HeartBeatModule module = new HeartBeatModule(new HashMap<String, String>());
        configuration.getTelemetryModules().add(module);
    }

    private boolean isHeartBeatModuleAdded(List<TelemetryModule> module) {
        for (TelemetryModule mod : module) {
            if (!(mod instanceof HeartBeatModule)) continue;
            return true;
        }
        return false;
    }

    @VisibleForTesting
    void setPerformanceCountersSection(String performanceCountersSection) {
        this.performanceCountersSection = performanceCountersSection;
    }

    static {
        defaultPerformaceModuleClassNames = new HashSet<String>();
        TelemetryConfigurationFactory.addDefaultPerfModuleClassName(ProcessPerformanceCountersModule.class.getCanonicalName());
        TelemetryConfigurationFactory.addDefaultPerfModuleClassName(JvmPerformanceCountersModule.class.getCanonicalName());
    }
}

