/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.common;

import com.microsoft.applicationinsights.core.dependencies.apachecommons.lang3.exception.ExceptionUtils;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class CommonUtils {
    public static boolean isNullOrEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public static String getHostName() {
        try {
            InetAddress addr = InetAddress.getLocalHost();
            return addr.getCanonicalHostName();
        }
        catch (UnknownHostException ex) {
            InternalLogger.INSTANCE.warn("Error resolving hostname:%n%s", ExceptionUtils.getStackTrace(ex));
            return null;
        }
    }

    public static boolean isClassPresentOnClassPath(String classSignature, ClassLoader classLoader) {
        try {
            Class.forName(classSignature, false, classLoader);
            return true;
        }
        catch (ClassNotFoundException e) {
            InternalLogger.INSTANCE.info("Specified class %s is not present on the classpath", classSignature);
            return false;
        }
    }
}

