/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.web.internal.cookies;

import com.microsoft.applicationinsights.internal.util.DateTimeUtils;
import com.microsoft.applicationinsights.internal.util.LocalStringsUtils;
import com.microsoft.applicationinsights.web.internal.cookies.Cookie;
import java.util.Date;

public class UserCookie
extends Cookie {
    public static final String COOKIE_NAME = "ai_user";
    private boolean isNewUser;
    private String userId;
    private Date acquisitionDate;

    public UserCookie(javax.servlet.http.Cookie cookie) throws Exception {
        this.parseCookie(cookie);
        this.isNewUser = false;
    }

    public UserCookie() {
        this.userId = LocalStringsUtils.generateRandomId(true);
        this.acquisitionDate = DateTimeUtils.getDateTimeNow();
        this.isNewUser = true;
    }

    public String getUserId() {
        return this.userId;
    }

    public Date getAcquisitionDate() {
        return this.acquisitionDate;
    }

    public boolean isNewUser() {
        return this.isNewUser;
    }

    private void parseCookie(javax.servlet.http.Cookie cookie) throws Exception {
        String[] split = cookie.getValue().split("\\|");
        if (split.length < CookieFields.values().length) {
            String errorMessage = String.format("Session cookie is not in the correct format: %s", cookie.getValue());
            throw new Exception(errorMessage);
        }
        try {
            this.userId = split[CookieFields.USER_ID.getValue()];
            this.acquisitionDate = DateTimeUtils.parseRoundTripDateString(split[CookieFields.ACQUISITION_DATE.getValue()]);
        }
        catch (Exception e) {
            String errorMessage = String.format("Failed to parse user cookie with exception: %s", e.getMessage());
            throw new Exception(errorMessage);
        }
    }

    private static enum CookieFields {
        USER_ID(0),
        ACQUISITION_DATE(1);

        private final int value;

        private CookieFields(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

