/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.web.extensibility.initializers;

import com.microsoft.applicationinsights.common.CommonUtils;
import com.microsoft.applicationinsights.telemetry.RequestTelemetry;
import com.microsoft.applicationinsights.telemetry.Telemetry;
import com.microsoft.applicationinsights.web.extensibility.initializers.WebTelemetryInitializerBase;
import com.microsoft.applicationinsights.web.internal.RequestTelemetryContext;
import com.microsoft.applicationinsights.web.internal.ThreadContext;

public class WebOperationNameTelemetryInitializer
extends WebTelemetryInitializerBase {
    @Override
    protected void onInitializeTelemetry(Telemetry telemetry) {
        RequestTelemetryContext telemetryContext = ThreadContext.getRequestTelemetryContext();
        String operationName = telemetryContext.getHttpRequestTelemetry().getName();
        this.updateRequestNameIfRequestTelemetry(telemetry, operationName);
        telemetry.getContext().getOperation().setName(operationName);
    }

    private void updateRequestNameIfRequestTelemetry(Telemetry telemetry, String operationName) {
        if (!(telemetry instanceof RequestTelemetry)) {
            return;
        }
        RequestTelemetry requestTelemetry = (RequestTelemetry)telemetry;
        if (requestTelemetry != null && CommonUtils.isNullOrEmpty(requestTelemetry.getName())) {
            requestTelemetry.setName(operationName);
        }
    }
}

