/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.logback.internal;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.ThrowableProxy;
import com.microsoft.applicationinsights.internal.common.ApplicationInsightsEvent;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.telemetry.SeverityLevel;
import java.util.HashMap;
import java.util.Map;

public final class ApplicationInsightsLogEvent
extends ApplicationInsightsEvent {
    private ILoggingEvent loggingEvent;

    public ApplicationInsightsLogEvent(ILoggingEvent loggingEvent) {
        this.loggingEvent = loggingEvent;
    }

    @Override
    public String getMessage() {
        return this.loggingEvent.getFormattedMessage();
    }

    @Override
    public boolean isException() {
        return this.loggingEvent.getThrowableProxy() != null;
    }

    @Override
    public Exception getException() {
        Exception exception = null;
        if (this.isException()) {
            Throwable throwable = ((ThrowableProxy)this.loggingEvent.getThrowableProxy()).getThrowable();
            exception = throwable instanceof Exception ? (Exception)throwable : new Exception(throwable);
        }
        return exception;
    }

    @Override
    public Map<String, String> getCustomParameters() {
        HashMap<String, String> metaData = new HashMap<String, String>();
        metaData.put("SourceType", "LOGBack");
        ApplicationInsightsLogEvent.addLogEventProperty("LoggerName", this.loggingEvent.getLoggerName(), metaData);
        ApplicationInsightsLogEvent.addLogEventProperty("LoggingLevel", this.loggingEvent.getLevel() != null ? this.loggingEvent.getLevel().levelStr : null, metaData);
        ApplicationInsightsLogEvent.addLogEventProperty("ThreadName", this.loggingEvent.getThreadName(), metaData);
        ApplicationInsightsLogEvent.addLogEventProperty("TimeStamp", ApplicationInsightsLogEvent.getFormattedDate(this.loggingEvent.getTimeStamp()), metaData);
        if (this.isException()) {
            ApplicationInsightsLogEvent.addLogEventProperty("Logger Message", this.getMessage(), metaData);
        }
        for (Map.Entry entry : this.loggingEvent.getMDCPropertyMap().entrySet()) {
            ApplicationInsightsLogEvent.addLogEventProperty((String)entry.getKey(), (String)entry.getValue(), metaData);
        }
        return metaData;
    }

    @Override
    public SeverityLevel getNormalizedSeverityLevel() {
        int log4jLevelAsInt = this.loggingEvent.getLevel().toInt();
        switch (log4jLevelAsInt) {
            case 40000: {
                return SeverityLevel.Error;
            }
            case 30000: {
                return SeverityLevel.Warning;
            }
            case 20000: {
                return SeverityLevel.Information;
            }
            case -2147483648: 
            case 5000: 
            case 10000: {
                return SeverityLevel.Verbose;
            }
        }
        InternalLogger.INSTANCE.error("Unknown Logback option, %d, using TRACE level as default", new Object[]{log4jLevelAsInt});
        return SeverityLevel.Verbose;
    }
}

