/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.util;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.ThreadLocalRandom;

public class LocalStringsUtils {
    private static final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZZ");

    public static boolean isNullOrEmpty(String value) {
        return value == null || value.isEmpty();
    }

    @SuppressFBWarnings(value={"SECPR"}, justification="Predictable random is ok for telemetry id")
    public static String generateRandomIntegerId() {
        long rand = ThreadLocalRandom.current().nextLong(Long.MAX_VALUE);
        return String.valueOf(rand);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatDate(Date value) {
        SimpleDateFormat simpleDateFormat = LocalStringsUtils.simpleDateFormat;
        synchronized (simpleDateFormat) {
            return LocalStringsUtils.simpleDateFormat.format(value);
        }
    }

    private LocalStringsUtils() {
    }
}

