/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.agent;

import com.microsoft.applicationinsights.agent.internal.sdk.AgentBridgeInternal;
import com.microsoft.applicationinsights.agent.internal.sdk.BindingResult;
import com.microsoft.applicationinsights.agent.internal.sdk.SdkBridge;
import com.microsoft.applicationinsights.core.dependencies.javaxannotation.Nullable;
import com.microsoft.applicationinsights.internal.agent.AgentBinding;
import com.microsoft.applicationinsights.internal.agent.AgentBridge;
import java.util.ArrayList;
import java.util.List;
import org.glowroot.instrumentation.api.ThreadContext;

class AgentBridgeImpl<T>
implements AgentBridge<T> {
    private final SdkBridge<T> sdkBridge;

    AgentBridgeImpl(SdkBridge<T> sdkBridge) {
        this.sdkBridge = sdkBridge;
    }

    @Override
    public boolean isAgentRunning() {
        return true;
    }

    @Override
    public AgentBinding bindToThread(T requestTelemetryContext, @Nullable AgentBridge.ServletRequestInfo servletRequestInfo) {
        return new AgentBindingImpl(AgentBridgeInternal.bindToThread(this.sdkBridge, requestTelemetryContext, (ThreadContext.ServletRequestInfo)new ServletRequestInfoImpl(servletRequestInfo)));
    }

    private static class ServletRequestInfoImpl
    implements ThreadContext.ServletRequestInfo {
        private final AgentBridge.ServletRequestInfo servletRequestInfo;
        private final List<String> jaxRsParts = new ArrayList<String>();

        private ServletRequestInfoImpl(AgentBridge.ServletRequestInfo servletRequestInfo) {
            this.servletRequestInfo = servletRequestInfo;
        }

        public String getMethod() {
            return this.servletRequestInfo.getMethod();
        }

        public String getContextPath() {
            return this.servletRequestInfo.getContextPath();
        }

        public String getServletPath() {
            return this.servletRequestInfo.getServletPath();
        }

        @Nullable
        public String getPathInfo() {
            return this.servletRequestInfo.getPathInfo();
        }

        public String getUri() {
            return this.servletRequestInfo.getUri();
        }

        public void addJaxRsPart(String part) {
            this.jaxRsParts.add(part);
        }

        public List<String> getJaxRsParts() {
            return this.jaxRsParts;
        }
    }

    private static class AgentBindingImpl
    implements AgentBinding {
        private final BindingResult bindingResult;

        AgentBindingImpl(BindingResult bindingResult) {
            this.bindingResult = bindingResult;
        }

        @Override
        public void unbindFromMainThread() {
            this.bindingResult.unbindFromMainThread();
        }

        @Override
        public void unbindFromRunawayChildThreads() {
            this.bindingResult.unbindFromRunawayChildThreads();
        }
    }
}

