/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.quickpulse;

import com.microsoft.applicationinsights.TelemetryConfiguration;
import com.microsoft.applicationinsights.core.dependencies.apachecommons.lang3.exception.ExceptionUtils;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.internal.perfcounter.CpuPerformanceCounterCalculator;
import com.microsoft.applicationinsights.telemetry.ExceptionTelemetry;
import com.microsoft.applicationinsights.telemetry.RemoteDependencyTelemetry;
import com.microsoft.applicationinsights.telemetry.RequestTelemetry;
import com.microsoft.applicationinsights.telemetry.Telemetry;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public enum QuickPulseDataCollector {
    INSTANCE;

    private String ikey;
    private TelemetryConfiguration config;
    private AtomicReference<Counters> counters = new AtomicReference<Object>(null);
    private final MemoryMXBean memory;
    private final CpuPerformanceCounterCalculator cpuPerformanceCounterCalculator;

    private QuickPulseDataCollector() {
        CpuPerformanceCounterCalculator temp;
        try {
            temp = new CpuPerformanceCounterCalculator();
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                InternalLogger.INSTANCE.error("Could not initialize %s:%n%s", CpuPerformanceCounterCalculator.class.getSimpleName(), ExceptionUtils.getStackTrace(t));
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            temp = null;
        }
        this.cpuPerformanceCounterCalculator = temp;
        this.memory = ManagementFactory.getMemoryMXBean();
    }

    public synchronized void disable() {
        this.counters.set(null);
    }

    @Deprecated
    public synchronized void enable(String ikey) {
        this.ikey = ikey;
        this.config = null;
        this.counters.set(new Counters());
    }

    public synchronized void enable(TelemetryConfiguration config) {
        this.config = config;
        this.ikey = null;
        this.counters.set(new Counters());
    }

    public synchronized FinalCounters getAndRestart() {
        Counters currentCounters = this.counters.getAndSet(new Counters());
        if (currentCounters != null) {
            return new FinalCounters(currentCounters, this.memory, this.cpuPerformanceCounterCalculator);
        }
        return null;
    }

    synchronized FinalCounters peek() {
        Counters currentCounters = this.counters.get();
        if (currentCounters != null) {
            return new FinalCounters(currentCounters, this.memory, this.cpuPerformanceCounterCalculator);
        }
        return null;
    }

    public void add(Telemetry telemetry) {
        if (!telemetry.getContext().getInstrumentationKey().equals(this.getInstrumentationKey())) {
            return;
        }
        if (telemetry instanceof RequestTelemetry) {
            RequestTelemetry requestTelemetry = (RequestTelemetry)telemetry;
            this.addRequest(requestTelemetry);
        } else if (telemetry instanceof RemoteDependencyTelemetry) {
            this.addDependency((RemoteDependencyTelemetry)telemetry);
        } else if (telemetry instanceof ExceptionTelemetry) {
            this.addException();
        }
    }

    private synchronized String getInstrumentationKey() {
        if (this.config != null) {
            return this.config.getInstrumentationKey();
        }
        return this.ikey;
    }

    private void addDependency(RemoteDependencyTelemetry telemetry) {
        Counters counters = this.counters.get();
        if (counters == null) {
            return;
        }
        counters.rddsAndDuations.addAndGet(Counters.encodeCountAndDuration(1L, telemetry.getDuration().getTotalMilliseconds()));
        if (!telemetry.getSuccess()) {
            counters.unsuccessfulRdds.incrementAndGet();
        }
    }

    private void addException() {
        Counters counters = this.counters.get();
        if (counters == null) {
            return;
        }
        counters.exceptions.incrementAndGet();
    }

    private void addRequest(RequestTelemetry requestTelemetry) {
        Counters counters = this.counters.get();
        if (counters == null) {
            return;
        }
        counters.requestsAndDurations.addAndGet(Counters.encodeCountAndDuration(1L, requestTelemetry.getDuration().getTotalMilliseconds()));
        if (!requestTelemetry.isSuccess()) {
            counters.unsuccessfulRequests.incrementAndGet();
        }
    }

    static class Counters {
        private static final long MAX_COUNT = 524287L;
        private static final long MAX_DURATION = 0xFFFFFFFFFFFL;
        public final AtomicInteger exceptions = new AtomicInteger(0);
        final AtomicLong requestsAndDurations = new AtomicLong(0L);
        final AtomicInteger unsuccessfulRequests = new AtomicInteger(0);
        final AtomicLong rddsAndDuations = new AtomicLong(0L);
        final AtomicInteger unsuccessfulRdds = new AtomicInteger(0);

        Counters() {
        }

        static long encodeCountAndDuration(long count, long duration) {
            if (count > 524287L || duration > 0xFFFFFFFFFFFL) {
                return 0L;
            }
            return (count << 44) + duration;
        }

        static CountAndDuration decodeCountAndDuration(long countAndDuration) {
            return new CountAndDuration(countAndDuration >> 44, countAndDuration & 0xFFFFFFFFFFFL);
        }
    }

    static class CountAndDuration {
        public final long count;
        public final long duration;

        private CountAndDuration(long count, long duration) {
            this.count = count;
            this.duration = duration;
        }
    }

    static class FinalCounters {
        public final double exceptions;
        public final long requests;
        public final double requestsDuration;
        public final long unsuccessfulRequests;
        public final long rdds;
        public final double rddsDuration;
        public final long unsuccessfulRdds;
        public final long memoryCommitted;
        public final double cpuUsage;

        public FinalCounters(Counters currentCounters, MemoryMXBean memory, CpuPerformanceCounterCalculator cpuPerformanceCounterCalculator) {
            Double cpuDatum;
            this.memoryCommitted = memory != null && memory.getHeapMemoryUsage() != null ? memory.getHeapMemoryUsage().getCommitted() : -1L;
            this.cpuUsage = cpuPerformanceCounterCalculator != null && (cpuDatum = cpuPerformanceCounterCalculator.getProcessCpuUsage()) != null ? cpuDatum : -1.0;
            this.exceptions = currentCounters.exceptions.get();
            CountAndDuration countAndDuration = Counters.decodeCountAndDuration(currentCounters.requestsAndDurations.get());
            this.requests = countAndDuration.count;
            this.requestsDuration = countAndDuration.duration;
            this.unsuccessfulRequests = currentCounters.unsuccessfulRequests.get();
            countAndDuration = Counters.decodeCountAndDuration(currentCounters.rddsAndDuations.get());
            this.rdds = countAndDuration.count;
            this.rddsDuration = countAndDuration.duration;
            this.unsuccessfulRdds = currentCounters.unsuccessfulRdds.get();
        }
    }
}

