/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.config.connection;

import com.microsoft.applicationinsights.core.dependencies.google.common.annotations.VisibleForTesting;
import java.net.URI;
import java.net.URISyntaxException;

public class EndpointProvider {
    @VisibleForTesting
    static final String INGESTION_URI_PATH = "v2/track";
    @VisibleForTesting
    static final String LIVE_URI_PATH = "QuickPulseService.svc";
    @VisibleForTesting
    static final String API_PROFILES_APP_ID_URI_PREFIX = "api/profiles/";
    @VisibleForTesting
    static final String API_PROFILES_APP_ID_URI_SUFFIX = "/appId";
    private volatile URI ingestionEndpoint;
    private volatile URI ingestionEndpointURL;
    private volatile URI liveEndpointURL;
    private volatile URI profilerEndpoint;
    private volatile URI snapshotEndpoint;

    public EndpointProvider() {
        try {
            this.ingestionEndpoint = new URI("https://dc.services.visualstudio.com");
            this.ingestionEndpointURL = this.buildIngestionUri(this.ingestionEndpoint);
            this.liveEndpointURL = this.buildLiveUri(new URI("https://rt.services.visualstudio.com"));
            this.profilerEndpoint = new URI("https://agent.azureserviceprofiler.net");
            this.snapshotEndpoint = new URI("https://agent.azureserviceprofiler.net");
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("ConnectionString.Defaults are invalid", e);
        }
    }

    private URI buildIngestionUri(URI baseUri) throws URISyntaxException {
        return this.buildUri(baseUri, INGESTION_URI_PATH);
    }

    private URI buildLiveUri(URI baseUri) throws URISyntaxException {
        return this.buildUri(baseUri, LIVE_URI_PATH);
    }

    public URI getIngestionEndpointURL() {
        return this.ingestionEndpointURL;
    }

    public synchronized URI getAppIdEndpointURL(String instrumentationKey) {
        return this.buildAppIdUri(instrumentationKey);
    }

    private URI buildAppIdUri(String instrumentationKey) {
        try {
            return this.buildUri(this.ingestionEndpoint, API_PROFILES_APP_ID_URI_PREFIX + instrumentationKey + API_PROFILES_APP_ID_URI_SUFFIX);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid instrumentationKey: " + instrumentationKey);
        }
    }

    URI buildUri(URI baseUri, String appendPath) throws URISyntaxException {
        String uriString = baseUri.toString();
        if (!uriString.endsWith("/")) {
            uriString = uriString + "/";
        }
        if (appendPath.startsWith("/")) {
            appendPath = appendPath.substring(1);
        }
        return new URI(uriString + appendPath);
    }

    public URI getIngestionEndpoint() {
        return this.ingestionEndpoint;
    }

    void setIngestionEndpoint(URI ingestionEndpoint) {
        try {
            this.ingestionEndpointURL = this.buildIngestionUri(ingestionEndpoint);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Could not construct ingestion endpoint uri", e);
        }
        this.ingestionEndpoint = ingestionEndpoint;
    }

    public URI getLiveEndpointURL() {
        return this.liveEndpointURL;
    }

    void setLiveEndpoint(URI liveEndpoint) {
        try {
            this.liveEndpointURL = this.buildLiveUri(liveEndpoint);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("could not construct live endpoint uri", e);
        }
    }

    public URI getProfilerEndpoint() {
        return this.profilerEndpoint;
    }

    void setProfilerEndpoint(URI profilerEndpoint) {
        this.profilerEndpoint = profilerEndpoint;
    }

    public URI getSnapshotEndpoint() {
        return this.snapshotEndpoint;
    }

    void setSnapshotEndpoint(URI snapshotEndpoint) {
        this.snapshotEndpoint = snapshotEndpoint;
    }
}

