/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.core.dependencies.xstream.converters.extended;

import com.microsoft.applicationinsights.core.dependencies.xstream.converters.ConversionException;
import com.microsoft.applicationinsights.core.dependencies.xstream.converters.basic.AbstractSingleValueConverter;
import com.microsoft.applicationinsights.core.dependencies.xstream.core.ClassLoaderReference;
import com.microsoft.applicationinsights.core.dependencies.xstream.mapper.CannotResolveClassException;
import com.microsoft.applicationinsights.core.dependencies.xstream.mapper.DefaultMapper;
import com.microsoft.applicationinsights.core.dependencies.xstream.mapper.Mapper;

public class JavaClassConverter
extends AbstractSingleValueConverter {
    private Mapper mapper;

    public JavaClassConverter(ClassLoaderReference classLoaderReference) {
        this(new DefaultMapper(classLoaderReference));
    }

    public JavaClassConverter(ClassLoader classLoader) {
        this(new ClassLoaderReference(classLoader));
    }

    protected JavaClassConverter(Mapper mapper) {
        this.mapper = mapper;
    }

    public boolean canConvert(Class clazz) {
        return Class.class.equals(clazz);
    }

    public String toString(Object obj) {
        return this.mapper.serializedClass((Class)obj);
    }

    public Object fromString(String str) {
        try {
            return this.mapper.realClass(str);
        }
        catch (CannotResolveClassException e) {
            throw new ConversionException("Cannot load java class " + str, e.getCause());
        }
    }
}

