/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.system;

import com.microsoft.applicationinsights.core.dependencies.apachecommons.lang3.SystemUtils;
import com.microsoft.applicationinsights.core.dependencies.google.common.base.Strings;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import java.lang.management.ManagementFactory;

public enum SystemInformation {
    INSTANCE;

    private static final String DEFAULT_PROCESS_NAME = "Java_Process";
    private final String processId = this.initializeProcessId();

    public String getProcessId() {
        return this.processId;
    }

    public boolean isWindows() {
        return SystemUtils.IS_OS_WINDOWS;
    }

    public boolean isUnix() {
        return SystemUtils.IS_OS_UNIX;
    }

    private String initializeProcessId() {
        int i;
        String rawName = ManagementFactory.getRuntimeMXBean().getName();
        if (!Strings.isNullOrEmpty(rawName) && (i = rawName.indexOf("@")) != -1) {
            String processIdAsString = rawName.substring(0, i);
            try {
                Integer.parseInt(processIdAsString);
                return processIdAsString;
            }
            catch (Exception e) {
                InternalLogger.INSTANCE.error("Failed to fetch process id: '%s'", e.toString());
            }
        }
        return DEFAULT_PROCESS_NAME;
    }
}

