/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.perfcounter;

import com.microsoft.applicationinsights.core.dependencies.google.common.base.Preconditions;
import com.microsoft.applicationinsights.core.dependencies.google.common.base.Strings;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.internal.perfcounter.JniPCConnector;

public final class WindowsPerformanceCounterData {
    @Deprecated
    public String displayName;
    @Deprecated
    public String categoryName;
    @Deprecated
    public String counterName;
    @Deprecated
    public String instanceName;

    public String getDisplayName() {
        return this.displayName;
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    public String getCounterName() {
        return this.counterName;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public WindowsPerformanceCounterData setDisplayName(String displayName) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(displayName), "displayName must be non-null and non empty value.");
        this.displayName = displayName;
        return this;
    }

    public WindowsPerformanceCounterData setCategoryName(String categoryName) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(categoryName), "categoryName must be non-null and non empty value.");
        this.categoryName = categoryName;
        return this;
    }

    public WindowsPerformanceCounterData setCounterName(String counterName) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(counterName), "counterName must be non-null and non empty value.");
        this.counterName = counterName;
        return this;
    }

    public WindowsPerformanceCounterData setInstanceName(String instanceName) throws Throwable {
        try {
            String translatedInstanceName;
            this.instanceName = translatedInstanceName = JniPCConnector.translateInstanceName(instanceName);
        }
        catch (Throwable e) {
            InternalLogger.INSTANCE.error("Failed to translate instance name '%s': '%s'", instanceName, e.toString());
            throw e;
        }
        return this;
    }
}

