/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.quickpulse;

import com.microsoft.applicationinsights.core.dependencies.http.Header;
import com.microsoft.applicationinsights.core.dependencies.http.HttpResponse;
import com.microsoft.applicationinsights.core.dependencies.http.client.methods.HttpPost;
import com.microsoft.applicationinsights.internal.quickpulse.QuickPulseStatus;
import java.util.Date;

final class QuickPulseNetworkHelper {
    private static final long TICKS_AT_EPOCH = 621355968000000000L;
    private static final String HEADER_TRANSMISSION_TIME = "x-ms-qps-transmission-time";
    private static final String QP_STATUS_HEADER = "x-ms-qps-subscribed";

    QuickPulseNetworkHelper() {
    }

    public HttpPost buildRequest(Date currentDate, String address) {
        long ticks = currentDate.getTime() * 10000L + 621355968000000000L;
        HttpPost request = new HttpPost(address);
        request.addHeader(HEADER_TRANSMISSION_TIME, String.valueOf(ticks));
        return request;
    }

    public boolean isSuccess(HttpResponse response) {
        int responseCode = response.getStatusLine().getStatusCode();
        return responseCode == 200;
    }

    public QuickPulseStatus getQuickPulseStatus(HttpResponse response) {
        Header header = response.getFirstHeader(QP_STATUS_HEADER);
        if (header != null) {
            String toPost = header.getValue();
            if ("true".equalsIgnoreCase(toPost)) {
                return QuickPulseStatus.QP_IS_ON;
            }
            return QuickPulseStatus.QP_IS_OFF;
        }
        return QuickPulseStatus.ERROR;
    }
}

