/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.perfcounter;

import com.microsoft.applicationinsights.TelemetryClient;
import com.microsoft.applicationinsights.core.dependencies.apachecommons.lang3.exception.ExceptionUtils;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.internal.perfcounter.AbstractUnixPerformanceCounter;
import com.microsoft.applicationinsights.internal.perfcounter.UnixProcessIOtParser;
import com.microsoft.applicationinsights.internal.system.SystemInformation;
import com.microsoft.applicationinsights.telemetry.PerformanceCounterTelemetry;
import java.io.BufferedReader;
import java.io.FileReader;

final class UnixProcessIOPerformanceCounter
extends AbstractUnixPerformanceCounter {
    private static final double NANOS_IN_SECOND = 1.0E9;
    private double prevProcessIO;
    private long lastCollectionInNanos = -1L;

    public UnixProcessIOPerformanceCounter() {
        super("/proc/" + SystemInformation.INSTANCE.getProcessId() + "/io");
    }

    @Override
    public String getId() {
        return "JSDK_ProcessIOPerformanceCounter";
    }

    @Override
    public void report(TelemetryClient telemetryClient) {
        long currentCollectionInNanos = System.nanoTime();
        double processIO = this.getCurrentIOForCurrentProcess();
        if (this.lastCollectionInNanos != -1L) {
            double timeElapsedInSeconds = (double)(currentCollectionInNanos - this.lastCollectionInNanos) / 1.0E9;
            double value = (processIO - this.prevProcessIO) / timeElapsedInSeconds;
            this.prevProcessIO = processIO;
            InternalLogger.INSTANCE.trace("Sending Performance Counter: %s %s: %s", UnixProcessIOPerformanceCounter.getProcessCategoryName(), "IO Data Bytes/sec", value);
            PerformanceCounterTelemetry telemetry = new PerformanceCounterTelemetry(UnixProcessIOPerformanceCounter.getProcessCategoryName(), "IO Data Bytes/sec", SystemInformation.INSTANCE.getProcessId(), value);
            telemetryClient.track(telemetry);
        }
        this.prevProcessIO = processIO;
        this.lastCollectionInNanos = currentCollectionInNanos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public double getCurrentIOForCurrentProcess() {
        String line;
        BufferedReader bufferedReader = null;
        double result = -1.0;
        UnixProcessIOtParser parser = new UnixProcessIOtParser();
        bufferedReader = new BufferedReader(new FileReader(this.getProcessFile()));
        while (!parser.done() && (line = bufferedReader.readLine()) != null) {
            parser.process(line);
        }
        result = parser.getValue();
        if (bufferedReader == null) return result;
        try {
            bufferedReader.close();
            return result;
        }
        catch (Exception e) {
            this.logError("Error while closing file : '%s'", e.getMessage());
            InternalLogger.INSTANCE.trace("Stack trace generated is %s", ExceptionUtils.getStackTrace(e));
        }
        return result;
        catch (Exception e) {
            try {
                result = -1.0;
                this.logError("Error while parsing file: '%s'", this.getId(), e.getMessage());
                InternalLogger.INSTANCE.trace("Stack trace generated is %s", ExceptionUtils.getStackTrace(e));
                if (bufferedReader == null) return result;
            }
            catch (Throwable throwable) {
                if (bufferedReader == null) throw throwable;
                try {
                    bufferedReader.close();
                    throw throwable;
                }
                catch (Exception e2) {
                    this.logError("Error while closing file : '%s'", e2.getMessage());
                    InternalLogger.INSTANCE.trace("Stack trace generated is %s", ExceptionUtils.getStackTrace(e2));
                }
                throw throwable;
            }
            try {
                bufferedReader.close();
                return result;
            }
            catch (Exception e3) {
                this.logError("Error while closing file : '%s'", e3.getMessage());
                InternalLogger.INSTANCE.trace("Stack trace generated is %s", ExceptionUtils.getStackTrace(e3));
            }
            return result;
        }
    }
}

