/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.perfcounter;

import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.internal.perfcounter.PerformanceCounter;
import com.microsoft.applicationinsights.internal.perfcounter.PerformanceCountersFactory;
import com.microsoft.applicationinsights.internal.perfcounter.jvm.DeadLockDetectorPerformanceCounter;
import com.microsoft.applicationinsights.internal.perfcounter.jvm.JvmHeapMemoryUsedPerformanceCounter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;

public class JvmPerformanceCountersFactory
implements PerformanceCountersFactory {
    private boolean isEnabled = true;
    private HashSet<String> disabledJvmPCs = new HashSet();

    @Override
    public Collection<PerformanceCounter> getPerformanceCounters() {
        ArrayList<PerformanceCounter> pcs = new ArrayList<PerformanceCounter>();
        if (this.isEnabled) {
            this.addDeadLockDetector(pcs);
            this.addJvmMemoryPerformanceCounter(pcs);
        } else {
            InternalLogger.INSTANCE.logAlways(InternalLogger.LoggingLevel.TRACE, "JvmPerformanceCountersFactory is disabled", new Object[0]);
        }
        return pcs;
    }

    private void addDeadLockDetector(ArrayList<PerformanceCounter> pcs) {
        try {
            if (this.disabledJvmPCs.contains("ThreadDeadLockDetector")) {
                InternalLogger.INSTANCE.logAlways(InternalLogger.LoggingLevel.TRACE, "DeadLockDetectorPerformanceCounter is disabled", new Object[0]);
                return;
            }
            DeadLockDetectorPerformanceCounter dlpc = new DeadLockDetectorPerformanceCounter();
            if (!dlpc.isSupported()) {
                InternalLogger.INSTANCE.logAlways(InternalLogger.LoggingLevel.TRACE, "DeadLockDetectorPerformanceCounter is not supported", new Object[0]);
                return;
            }
            pcs.add(dlpc);
        }
        catch (Throwable t) {
            InternalLogger.INSTANCE.logAlways(InternalLogger.LoggingLevel.ERROR, "Failed to create DeadLockDetector, exception: %s", t.getMessage());
        }
    }

    private void addJvmMemoryPerformanceCounter(ArrayList<PerformanceCounter> pcs) {
        try {
            if (this.disabledJvmPCs.contains("MemoryUsage")) {
                InternalLogger.INSTANCE.logAlways(InternalLogger.LoggingLevel.TRACE, "JvmHeapMemoryUsedPerformanceCounter is disabled", new Object[0]);
                return;
            }
            JvmHeapMemoryUsedPerformanceCounter mpc = new JvmHeapMemoryUsedPerformanceCounter();
            pcs.add(mpc);
        }
        catch (Throwable t) {
            InternalLogger.INSTANCE.logAlways(InternalLogger.LoggingLevel.ERROR, "Failed to create JvmHeapMemoryUsedPerformanceCounter, exception: %s", t.getMessage());
        }
    }

    public void setIsEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public void setDisabledJvmPCs(HashSet<String> disabledJvmPCs) {
        this.disabledJvmPCs = disabledJvmPCs;
    }
}

