/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.channel.common;

import com.microsoft.applicationinsights.core.dependencies.googlecommon.base.Preconditions;
import com.microsoft.applicationinsights.internal.channel.TransmissionOutput;
import com.microsoft.applicationinsights.internal.channel.common.Transmission;
import com.microsoft.applicationinsights.internal.channel.common.TransmissionPolicy;
import com.microsoft.applicationinsights.internal.channel.common.TransmissionPolicyStateFetcher;
import com.microsoft.applicationinsights.internal.util.ThreadPoolUtils;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class ActiveTransmissionNetworkOutput
implements TransmissionOutput {
    private static final int DEFAULT_MAX_MESSAGES_IN_BUFFER = 128;
    private static final int DEFAULT_MIN_NUMBER_OF_THREADS = 7;
    private static final int DEFAULT_MAX_NUMBER_OF_THREADS = 7;
    private static final long DEFAULT_REMOVE_IDLE_THREAD_TIMEOUT_IN_SECONDS = 60L;
    private final int maxThreads;
    private final ThreadPoolExecutor outputThreads;
    private final TransmissionOutput actualOutput;
    private final TransmissionPolicyStateFetcher transmissionPolicy;

    public ActiveTransmissionNetworkOutput(TransmissionOutput actualOutput, TransmissionPolicyStateFetcher transmissionPolicy) {
        this(actualOutput, transmissionPolicy, 128);
    }

    public ActiveTransmissionNetworkOutput(TransmissionOutput actualOutput, TransmissionPolicyStateFetcher transmissionPolicy, int maxMessagesInBuffer) {
        Preconditions.checkNotNull(transmissionPolicy, "transmissionPolicy must be a valid non-null value");
        this.actualOutput = actualOutput;
        this.transmissionPolicy = transmissionPolicy;
        this.maxThreads = 7;
        this.outputThreads = ThreadPoolUtils.newLimitedThreadPool(7, this.maxThreads, 60L, maxMessagesInBuffer);
        this.outputThreads.setThreadFactory(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r);
                thread.setDaemon(true);
                return thread;
            }
        });
    }

    @Override
    public boolean send(final Transmission transmission) {
        try {
            if (this.transmissionPolicy.getCurrentState() != TransmissionPolicy.UNBLOCKED) {
                return false;
            }
            this.outputThreads.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        ActiveTransmissionNetworkOutput.this.actualOutput.send(transmission);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            });
            return true;
        }
        catch (RejectedExecutionException rejectedExecutionException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Override
    public void stop(long timeout, TimeUnit timeUnit) {
        this.actualOutput.stop(timeout, timeUnit);
        ThreadPoolUtils.stop(this.outputThreads, timeout, timeUnit);
    }

    public int getNumberOfMaxThreads() {
        return this.maxThreads;
    }
}

