/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.telemetry;

import com.google.common.base.Strings;
import com.microsoft.applicationinsights.extensibility.context.ComponentContext;
import com.microsoft.applicationinsights.extensibility.context.DeviceContext;
import com.microsoft.applicationinsights.extensibility.context.InternalContext;
import com.microsoft.applicationinsights.extensibility.context.LocationContext;
import com.microsoft.applicationinsights.extensibility.context.OperationContext;
import com.microsoft.applicationinsights.extensibility.context.SessionContext;
import com.microsoft.applicationinsights.extensibility.context.UserContext;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.internal.util.MapUtil;
import com.microsoft.applicationinsights.internal.util.Sanitizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class TelemetryContext {
    private ConcurrentMap<String, String> properties;
    private ConcurrentMap<String, String> tags;
    private String instrumentationKey;
    private ComponentContext component;
    private DeviceContext device;
    private SessionContext session;
    private UserContext user;
    private OperationContext operation;
    private LocationContext location;
    private InternalContext internal;

    public TelemetryContext() {
        this(new ConcurrentHashMap<String, String>(), new ConcurrentHashMap<String, String>());
    }

    public ComponentContext getComponent() {
        if (this.component == null) {
            this.component = new ComponentContext(this.tags);
        }
        return this.component;
    }

    public DeviceContext getDevice() {
        if (this.device == null) {
            this.device = new DeviceContext(this.tags);
        }
        return this.device;
    }

    public SessionContext getSession() {
        if (this.session == null) {
            this.session = new SessionContext(this.tags);
        }
        return this.session;
    }

    public UserContext getUser() {
        if (this.user == null) {
            this.user = new UserContext(this.tags);
        }
        return this.user;
    }

    public OperationContext getOperation() {
        if (this.operation == null) {
            this.operation = new OperationContext(this.tags);
        }
        return this.operation;
    }

    public LocationContext getLocation() {
        if (this.location == null) {
            this.location = new LocationContext(this.tags);
        }
        return this.location;
    }

    public String getInstrumentationKey() {
        return this.instrumentationKey;
    }

    public void setInstrumentationKey(String instrumentationKey) {
        if (!Sanitizer.isUUID(instrumentationKey)) {
            InternalLogger.INSTANCE.trace("Telemetry Configuration: illegal instrumentation key: %s", instrumentationKey);
        }
        this.instrumentationKey = instrumentationKey;
    }

    public ConcurrentMap<String, String> getProperties() {
        return this.properties;
    }

    public ConcurrentMap<String, String> getTags() {
        return this.tags;
    }

    public void initialize(TelemetryContext source) {
        if (Strings.isNullOrEmpty((String)this.instrumentationKey) && !Strings.isNullOrEmpty((String)source.getInstrumentationKey())) {
            this.setInstrumentationKey(source.getInstrumentationKey());
        }
        if (source.tags != null && source.tags.size() > 0) {
            MapUtil.copy(source.tags, this.tags);
        }
        if (source.properties != null && source.properties.size() > 0) {
            MapUtil.copy(source.properties, this.properties);
        }
    }

    public InternalContext getInternal() {
        if (this.internal == null) {
            this.internal = new InternalContext(this.tags);
        }
        return this.internal;
    }

    TelemetryContext(ConcurrentMap<String, String> properties, ConcurrentMap<String, String> tags) {
        if (properties == null) {
            throw new IllegalArgumentException("properties cannot be null");
        }
        if (tags == null) {
            throw new IllegalArgumentException("tags cannot be null");
        }
        this.properties = properties;
        this.tags = tags;
    }
}

