/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.telemetry;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.microsoft.applicationinsights.internal.schemav2.PerformanceCounterData;
import com.microsoft.applicationinsights.telemetry.BaseTelemetry;

public final class PerformanceCounterTelemetry
extends BaseTelemetry<PerformanceCounterData> {
    private final PerformanceCounterData data;

    public PerformanceCounterTelemetry() {
        this.data = new PerformanceCounterData();
        this.initialize(this.data.getProperties());
    }

    public PerformanceCounterTelemetry(String categoryName, String counterName, String instanceName, double value) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)categoryName) ? 1 : 0) != 0, (Object)"categoryName must be non null, non empty value");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)counterName) ? 1 : 0) != 0, (Object)"counterName must be non null, non empty value");
        this.data = new PerformanceCounterData();
        this.initialize(this.data.getProperties());
        this.data.setCategoryName(categoryName);
        this.data.setCounterName(counterName);
        this.data.setInstanceName(instanceName);
        this.data.setValue(value);
    }

    public void setCategoryName(String categoryName) {
        this.data.setCategoryName(categoryName);
    }

    public String getCategoryName() {
        return this.data.getCategoryName();
    }

    public void setCounterName(String counterName) {
        this.data.setCounterName(counterName);
    }

    public String getCounterName() {
        return this.data.getCounterName();
    }

    public void setInstanceName(String instanceName) {
        this.data.setInstanceName(instanceName);
    }

    public String getInstanceName() {
        return this.data.getInstanceName();
    }

    public void setValue(double value) {
        this.data.setValue(value);
    }

    public double getValue() {
        return this.data.getValue();
    }

    @Override
    protected void additionalSanitize() {
    }

    @Override
    protected PerformanceCounterData getData() {
        return this.data;
    }
}

