/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.telemetry;

import com.google.common.base.Strings;
import com.microsoft.applicationinsights.internal.schemav2.EventData;
import com.microsoft.applicationinsights.internal.util.Sanitizer;
import com.microsoft.applicationinsights.telemetry.BaseTelemetry;
import java.util.concurrent.ConcurrentMap;

public final class EventTelemetry
extends BaseTelemetry<EventData> {
    private final EventData data = new EventData();

    public EventTelemetry() {
        this.initialize(this.data.getProperties());
    }

    public EventTelemetry(String name) {
        this();
        this.setName(name);
    }

    public ConcurrentMap<String, Double> getMetrics() {
        return this.data.getMeasurements();
    }

    public String getName() {
        return this.data.getName();
    }

    public void setName(String name) {
        if (Strings.isNullOrEmpty((String)name)) {
            throw new IllegalArgumentException("The event name cannot be null or empty");
        }
        this.data.setName(name);
    }

    @Override
    protected void additionalSanitize() {
        this.data.setName(Sanitizer.sanitizeName(this.data.getName()));
        Sanitizer.sanitizeMeasurements(this.getMetrics());
    }

    @Override
    protected EventData getData() {
        return this.data;
    }
}

