/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.telemetry;

import com.microsoft.applicationinsights.internal.schemav2.Data;
import com.microsoft.applicationinsights.internal.schemav2.Envelope;
import com.microsoft.applicationinsights.internal.schemav2.SendableData;
import com.microsoft.applicationinsights.internal.util.LocalStringsUtils;
import com.microsoft.applicationinsights.internal.util.Sanitizer;
import com.microsoft.applicationinsights.telemetry.JsonTelemetryDataSerializer;
import com.microsoft.applicationinsights.telemetry.Telemetry;
import com.microsoft.applicationinsights.telemetry.TelemetryContext;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public abstract class BaseTelemetry<T extends SendableData>
implements Telemetry {
    private TelemetryContext context;
    private Date timestamp;
    private String sequence;

    protected BaseTelemetry() {
    }

    protected void initialize(ConcurrentMap<String, String> properties) {
        this.context = new TelemetryContext(properties, new ConcurrentHashMap<String, String>());
    }

    @Override
    public String getSequence() {
        return this.sequence;
    }

    @Override
    public void setSequence(String sequence) {
        this.sequence = sequence;
    }

    @Override
    public Date getTimestamp() {
        return this.timestamp;
    }

    @Override
    public void setTimestamp(Date date) {
        this.timestamp = date;
    }

    @Override
    public TelemetryContext getContext() {
        return this.context;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.context.getProperties();
    }

    @Override
    public void sanitize() {
        Sanitizer.sanitizeProperties(this.getProperties());
        this.additionalSanitize();
    }

    @Override
    public void serialize(JsonTelemetryDataSerializer writer) throws IOException {
        Envelope envelope = new Envelope();
        envelope.setIKey(this.context.getInstrumentationKey());
        envelope.setSeq(this.sequence);
        envelope.setData(new Data<T>(this.getData()));
        envelope.setTime(LocalStringsUtils.getDateFormatter().format(this.getTimestamp()));
        envelope.setTags(this.context.getTags());
        envelope.serialize(writer);
    }

    protected abstract void additionalSanitize();

    protected abstract T getData();
}

