/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.processor;

import com.microsoft.applicationinsights.agent.internal.common.StringUtils;
import com.microsoft.applicationinsights.extensibility.TelemetryProcessor;
import com.microsoft.applicationinsights.internal.annotation.BuiltInProcessor;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.telemetry.SeverityLevel;
import com.microsoft.applicationinsights.telemetry.Telemetry;
import com.microsoft.applicationinsights.telemetry.TraceTelemetry;
import java.util.HashMap;

@BuiltInProcessor(value="TraceTelemetryFilter")
public final class TraceTelemetryFilter
implements TelemetryProcessor {
    private SeverityLevel fromSeverityLevel = null;

    @Override
    public boolean process(Telemetry telemetry) {
        if (telemetry == null) {
            return true;
        }
        if (!(telemetry instanceof TraceTelemetry)) {
            return true;
        }
        if (this.fromSeverityLevel == null) {
            return false;
        }
        TraceTelemetry tt = (TraceTelemetry)telemetry;
        String message = tt.getMessage();
        if (StringUtils.isNullOrEmpty((String)message)) {
            return true;
        }
        if (tt.getSeverityLevel() == null) {
            return true;
        }
        return tt.getSeverityLevel().compareTo(this.fromSeverityLevel) >= 0;
    }

    public void setFromSeverityLevel(String fromSeverityLevel) throws Throwable {
        try {
            String trimmed = fromSeverityLevel.trim();
            if (trimmed.toUpperCase().equals("OFF")) {
                fromSeverityLevel = null;
            } else {
                HashMap<String, SeverityLevel> severityLevels = new HashMap<String, SeverityLevel>();
                severityLevels.put("TRACE", SeverityLevel.Verbose);
                severityLevels.put("INFO", SeverityLevel.Information);
                severityLevels.put("WARN", SeverityLevel.Warning);
                severityLevels.put("ERROR", SeverityLevel.Error);
                severityLevels.put("CRITICAL", SeverityLevel.Critical);
                SeverityLevel sl = (SeverityLevel)((Object)severityLevels.get(trimmed.toUpperCase()));
                if (sl == null) {
                    throw new IllegalArgumentException(String.format("Unknown option: %s", fromSeverityLevel));
                }
                this.fromSeverityLevel = sl;
            }
            InternalLogger.INSTANCE.trace(String.format("TraceTelemetryFilter: set severity level to %s", new Object[]{this.fromSeverityLevel}), new Object[0]);
        }
        catch (Throwable e) {
            this.fromSeverityLevel = SeverityLevel.Verbose;
            InternalLogger.INSTANCE.logAlways(InternalLogger.LoggingLevel.ERROR, String.format("TraceTelemetryFilter: failed to parse: %s", fromSeverityLevel), new Object[0]);
            throw e;
        }
    }
}

