/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.perfcounter;

import com.microsoft.applicationinsights.internal.perfcounter.UnixParsingState;

final class UnixTotalMemInfoParser {
    private static final String MEM_FREE_PREFIX = "MemFree:";
    private static final String BUFFERS_PREFIX = "Buffers";
    private static final String CACHED_PREFIX = "Cached";
    boolean memFreeDone = false;
    boolean buffersDone = false;
    boolean cachedDone = false;
    UnixParsingState state = new UnixParsingState(3);

    UnixTotalMemInfoParser() {
    }

    boolean done() {
        return this.state.doneCounter == 0;
    }

    void process(String line) {
        if (this.done()) {
            return;
        }
        if (!this.memFreeDone && this.parseValue(this.state, line, MEM_FREE_PREFIX)) {
            this.memFreeDone = true;
            return;
        }
        if (!this.buffersDone && this.parseValue(this.state, line, BUFFERS_PREFIX)) {
            this.buffersDone = true;
            return;
        }
        if (!this.cachedDone && this.parseValue(this.state, line, CACHED_PREFIX)) {
            this.cachedDone = true;
            return;
        }
    }

    public double getValue() {
        return this.state.returnValue;
    }

    private boolean parseValue(UnixParsingState parsingData, String line, String part) {
        int index = line.indexOf(part);
        if (index != -1) {
            line.trim();
            String[] strings = line.split(" ");
            parsingData.returnValue += Double.valueOf(strings[strings.length - 2]).doubleValue();
            --parsingData.doneCounter;
            return true;
        }
        return false;
    }
}

