/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.logger;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.microsoft.applicationinsights.internal.logger.ConsoleLoggerOutput;
import com.microsoft.applicationinsights.internal.logger.DefaultLogFileProxyFactory;
import com.microsoft.applicationinsights.internal.logger.LogFileProxy;
import com.microsoft.applicationinsights.internal.logger.LogFileProxyFactory;
import com.microsoft.applicationinsights.internal.logger.LoggerOutput;
import com.microsoft.applicationinsights.internal.util.LocalFileSystemUtils;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;

public final class FileLoggerOutput
implements LoggerOutput {
    private static final int MIN_SIZE_PER_LOG_FILE_IN_MB = 5;
    private static final int MAX_SIZE_PER_LOG_FILE_IN_MB = 500;
    private static final int MIN_NUMBER_OF_LOG_FILES = 2;
    private static String SDK_LOGS_DEFAULT_FOLDER = "javasdklogs";
    private static final String LOG_FILE_SUFFIX_FOR_LISTING = "jsl";
    private static final String NUMBER_OF_FILES_ATTRIBUTE = "NumberOfFiles";
    private static final String TOTAL_SIZE_OF_LOG_FILES_IN_MB_ATTRIBUTE = "NumberOfTotalSizeInMB";
    private static final String LOG_FILES_BASE_FOLDER_ATTRIBUTE = "BaseFolder";
    private static final String UNIQUE_LOG_FILE_PREFIX_ATTRIBUTE = "UniquePrefix";
    private static final String DATE_FORMAT_NOW = "yyyy-MM-dd-HH-mm-ss";
    private String uniquePrefix;
    private LogFileProxy[] files;
    private int maxSizePerFileInMB;
    private int currentLogFileIndex;
    private File baseFolder;
    private LogFileProxyFactory factory;
    private SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
    private ConsoleLoggerOutput fallbackLoggerOutput = new ConsoleLoggerOutput();

    public FileLoggerOutput(Map<String, String> loggerData) {
        this.uniquePrefix = loggerData.get(UNIQUE_LOG_FILE_PREFIX_ATTRIBUTE);
        if (Strings.isNullOrEmpty((String)this.uniquePrefix)) {
            throw new IllegalArgumentException(String.format("Unique log file prefix is not defined", new Object[0]));
        }
        this.uniquePrefix = this.uniquePrefix + '-';
        int numberOfFiles = this.getRequest(loggerData, NUMBER_OF_FILES_ATTRIBUTE, 2);
        int numberOfTotalMB = this.getRequest(loggerData, TOTAL_SIZE_OF_LOG_FILES_IN_MB_ATTRIBUTE, 5);
        String baseFolderName = loggerData.get(LOG_FILES_BASE_FOLDER_ATTRIBUTE);
        this.factory = new DefaultLogFileProxyFactory();
        this.initialize(baseFolderName, numberOfFiles, numberOfTotalMB);
    }

    private int getRequest(Map<String, String> loggerData, String requestName, int defaultValue) {
        int requestValue = defaultValue;
        String requestValueAsString = loggerData.get(requestName);
        if (!Strings.isNullOrEmpty((String)requestValueAsString)) {
            try {
                requestValue = Integer.valueOf(loggerData.get(requestName));
            }
            catch (Exception e) {
                this.fallbackLoggerOutput.log(String.format("Error: invalid value '%s' for '%s', using default: %d", requestValueAsString, requestName, defaultValue));
            }
        }
        return requestValue;
    }

    private void initialize(String baseFolderName, int numberOfFiles, int numberOfTotalMB) {
        this.currentLogFileIndex = 0;
        if (Strings.isNullOrEmpty((String)baseFolderName)) {
            baseFolderName = SDK_LOGS_DEFAULT_FOLDER;
        }
        if (numberOfFiles < 2) {
            numberOfFiles = 2;
        }
        this.files = new LogFileProxy[numberOfFiles];
        int tempSizePerFileInMB = numberOfTotalMB / numberOfFiles;
        if (tempSizePerFileInMB < 5) {
            tempSizePerFileInMB = 5;
        } else if (tempSizePerFileInMB > 500) {
            tempSizePerFileInMB = 500;
        }
        this.maxSizePerFileInMB = tempSizePerFileInMB;
        this.baseFolder = new File(LocalFileSystemUtils.getTempDir(), baseFolderName);
        if (!this.baseFolder.exists()) {
            this.baseFolder.mkdirs();
        } else {
            this.attachToExisting();
        }
    }

    @Override
    public synchronized void log(String message) {
        try {
            LogFileProxy logFileProxy = this.getCurrentLogFileProxy();
            if (logFileProxy != null) {
                logFileProxy.writeLine(message);
            }
        }
        catch (IOException e) {
            this.fallbackLoggerOutput.log(String.format("Failed to write to log to file exception: %s. Message '%s'", e.getMessage(), message));
        }
    }

    @Override
    public void close() {
        LogFileProxy currentLogger = this.files[this.currentLogFileIndex];
        if (currentLogger != null) {
            try {
                this.files[this.currentLogFileIndex] = null;
                currentLogger.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    void setLogProxyFactory(LogFileProxyFactory factory) {
        this.factory = factory;
    }

    private LogFileProxy getCurrentLogFileProxy() throws IOException {
        LogFileProxy currentProxy = this.files[this.currentLogFileIndex];
        if (currentProxy != null && !currentProxy.isFull()) {
            return currentProxy;
        }
        return this.createNewFileProxy();
    }

    private LogFileProxy createNewFileProxy() throws IOException {
        LogFileProxy logFileProxy;
        LogFileProxy currentLogger = this.files[this.currentLogFileIndex];
        if (currentLogger != null) {
            try {
                currentLogger.close();
            }
            catch (IOException e) {
                this.fallbackLoggerOutput.log(String.format("Failed to close log file, exception: %s", e.getMessage()));
            }
        }
        ++this.currentLogFileIndex;
        if (this.currentLogFileIndex == this.files.length) {
            this.currentLogFileIndex = 0;
        }
        if ((currentLogger = this.files[this.currentLogFileIndex]) != null) {
            this.files[this.currentLogFileIndex] = null;
            try {
                currentLogger.delete();
            }
            catch (Exception e) {
                this.fallbackLoggerOutput.log(String.format("Failed to delete log file, exception: %s", e.getMessage()));
            }
        }
        Calendar cal = Calendar.getInstance();
        String filePrefix = this.uniquePrefix + this.simpleDateFormat.format(cal.getTime());
        this.files[this.currentLogFileIndex] = logFileProxy = this.factory.create(this.baseFolder, filePrefix, this.maxSizePerFileInMB);
        return logFileProxy;
    }

    private void attachToExisting() {
        try {
            List<FileAndDate> oldLogs = this.getExistingLogsFromNewToOld();
            this.attachToExisting(oldLogs);
        }
        catch (Exception e) {
            this.fallbackLoggerOutput.log(String.format("Failed to delete old log file, exception: %s", e.getMessage()));
        }
    }

    private void attachToExisting(List<FileAndDate> oldLogs) {
        if (oldLogs.isEmpty()) {
            return;
        }
        int filesIndex = this.currentLogFileIndex;
        int numberOfFilesFound = 0;
        for (FileAndDate oldLog : oldLogs) {
            try {
                if (numberOfFilesFound < this.files.length) {
                    LogFileProxy logFileProxy = this.factory.attach(oldLog.file, this.maxSizePerFileInMB);
                    if (logFileProxy == null) continue;
                    ++numberOfFilesFound;
                    this.files[filesIndex] = logFileProxy;
                    ++filesIndex;
                    continue;
                }
                oldLog.file.delete();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private List<FileAndDate> getExistingLogsFromNewToOld() {
        try {
            Collection oldLogs = FileUtils.listFiles((File)this.baseFolder, (String[])new String[]{LOG_FILE_SUFFIX_FOR_LISTING}, (boolean)false);
            List asList = !(oldLogs instanceof List) ? Lists.newArrayList((Iterable)oldLogs) : (List)oldLogs;
            ArrayList<FileAndDate> filesByDate = new ArrayList<FileAndDate>();
            for (File file : asList) {
                Date fileDate = this.getFileDate(file);
                if (fileDate == null) continue;
                filesByDate.add(new FileAndDate(file, fileDate));
            }
            Collections.sort(filesByDate, new Comparator<FileAndDate>(){

                @Override
                public int compare(FileAndDate file1, FileAndDate file2) {
                    if (file1.date.before(file2.date)) {
                        return 1;
                    }
                    if (file2.date.before(file1.date)) {
                        return -1;
                    }
                    return 0;
                }
            });
            return filesByDate;
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }

    private Date getFileDate(File file) {
        try {
            String fileName = FilenameUtils.getBaseName((String)file.getName());
            int index = fileName.indexOf(this.uniquePrefix);
            if (index != -1) {
                String dateString = fileName.substring(index + this.uniquePrefix.length(), index + this.uniquePrefix.length() + DATE_FORMAT_NOW.length());
                Date date = this.simpleDateFormat.parse(dateString);
                return date;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static class FileAndDate {
        public final File file;
        public final Date date;

        private FileAndDate(File file, Date date) {
            this.file = file;
            this.date = date;
        }
    }
}

